/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.rlines;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLineWrapper;
import uk.ac.ebi.kraken.ffwriter.line.impl.rlines.RLine;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Book;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Editor;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.ElectronicArticle;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.JournalArticle;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Patent;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Submission;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.SubmissionDatabase;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Thesis;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.UnpublishedObservations;

public class RLLineBuilder
implements RLine<Citation> {
    private static final String LINE_PREFIX = (Object)((Object)LineType.RL) + "   ";

    @Override
    public List<String> buildLine(Citation citation, boolean includeFFMarkup, boolean showEvidence) {
        switch (citation.getCitationType()) {
            case BOOK: {
                return this.book(citation, includeFFMarkup);
            }
            case ELECTRONIC_ARTICLE: {
                return this.electronicArticle(citation, includeFFMarkup);
            }
            case JOURNAL_ARTICLE: {
                return this.journalArticle(citation, includeFFMarkup);
            }
            case UNPUBLISHED_JOURNAL_ARTICLE: {
                return this.journalArticle(citation, includeFFMarkup);
            }
            case PATENT: {
                return this.patent(citation, includeFFMarkup);
            }
            case SUBMISSION: {
                return this.submission(citation, includeFFMarkup);
            }
            case THESIS: {
                return this.thesis(citation, includeFFMarkup);
            }
            case UNPUBLISHED_OBSERVATIONS: {
                return this.unpublishedObservations(citation, includeFFMarkup);
            }
            case UNKNOWN: {
                throw new IllegalArgumentException("You specified that you wanted to write an unknown citation type.The RLLine does not know how to deal with this!");
            }
        }
        return new ArrayList<String>();
    }

    private List<String> journalArticle(Citation citation, boolean includeFFMarkup) {
        JournalArticle journalArticle = (JournalArticle)citation;
        StringBuilder result = new StringBuilder();
        if (includeFFMarkup) {
            result.append(LINE_PREFIX);
        }
        result.append(journalArticle.getJournalName().getValue());
        result.append(" ");
        result.append(journalArticle.getVolume().getValue());
        result.append(":");
        result.append(journalArticle.getFirstPage().getValue());
        result.append("-");
        result.append(journalArticle.getLastPage().getValue());
        result.append("(");
        String date = journalArticle.getPublicationDate().getValue();
        result.append(date);
        result.append(")");
        result.append(".");
        if (includeFFMarkup) {
            return FFLineWrapper.buildLines(result.toString(), " ", LINE_PREFIX, 80);
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(result.toString());
        return lines;
    }

    private List<String> electronicArticle(Citation citation, boolean includeFFMarkup) {
        StringBuilder result = new StringBuilder();
        ElectronicArticle electronicArticle = (ElectronicArticle)citation;
        if (includeFFMarkup) {
            result.append(LINE_PREFIX);
        }
        if (electronicArticle.getJournalName().getValue().startsWith(" ")) {
            result.append("(er)");
            result.append(electronicArticle.getJournalName().getValue());
        } else {
            result.append("(er) ");
            result.append(electronicArticle.getJournalName().getValue());
        }
        if (electronicArticle.getLocator() != null && !electronicArticle.getLocator().getValue().equals("")) {
            result.append(" ");
            result.append(electronicArticle.getLocator().getValue());
        }
        if (citation.getPublicationDate() != null && !citation.getPublicationDate().getValue().isEmpty()) {
            result.append("(").append(citation.getPublicationDate().getValue()).append(")");
        }
        result.append(".");
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(result.toString());
        return lines;
    }

    private List<String> patent(Citation citation, boolean includeFFMarkup) {
        StringBuilder result = new StringBuilder();
        if (includeFFMarkup) {
            result.append(LINE_PREFIX);
        }
        result.append("Patent number ");
        Patent patent = (Patent)citation;
        result.append(patent.getPatentNumber());
        result.append(", ");
        String date = patent.getPublicationDate().getValue();
        result.append(date);
        result.append(".");
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(result.toString());
        return lines;
    }

    private List<String> thesis(Citation citation, boolean includeFFMarkup) {
        StringBuilder result = new StringBuilder();
        Thesis thesis = (Thesis)citation;
        if (includeFFMarkup) {
            result.append(LINE_PREFIX);
        }
        result.append("Thesis (");
        String date = thesis.getPublicationDate().getValue();
        result.append(date);
        result.append("), ");
        result.append(thesis.getInstitute().getValue());
        if (thesis.getCity().getValue().length() > 0) {
            result.append(", ");
            result.append(thesis.getCity().getValue());
        }
        if (thesis.getCountry().getValue() != null && thesis.getCountry().getValue().length() > 0) {
            result.append(", ");
            result.append(thesis.getCountry().getValue());
        }
        result.append(".");
        if (includeFFMarkup) {
            return FFLineWrapper.buildLines(result.toString(), " ", LINE_PREFIX, 80);
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(result.toString());
        return lines;
    }

    private List<String> submission(Citation citation, boolean includeFFMarkup) {
        StringBuilder result = new StringBuilder();
        Submission submission = (Submission)citation;
        if (includeFFMarkup) {
            result.append(LINE_PREFIX);
        }
        result.append("Submitted");
        result.append(" (");
        String date = submission.getPublicationDate().getValue();
        result.append(date);
        if (submission.getSubmittedToDatabase().equals((Object)SubmissionDatabase.SWISS_PROT) || submission.getSubmittedToDatabase().equals((Object)SubmissionDatabase.UNIPROTKB)) {
            result.append(") to ");
        } else {
            result.append(") to the ");
        }
        result.append(submission.getSubmittedToDatabase().getValue());
        result.append(".");
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(result.toString());
        return lines;
    }

    private List<String> unpublishedObservations(Citation citation, boolean includeFFMarkup) {
        StringBuilder result = new StringBuilder();
        if (includeFFMarkup) {
            result.append(LINE_PREFIX);
        }
        UnpublishedObservations observations = (UnpublishedObservations)citation;
        result.append("Unpublished observations (");
        String date = observations.getPublicationDate().getValue();
        result.append(date);
        result.append(")");
        result.append(".");
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(result.toString());
        return lines;
    }

    private List<String> book(Citation citation, boolean includeFFMarkup) {
        boolean hasPages;
        Book book = (Book)citation;
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder temp = new StringBuilder();
        if (includeFFMarkup) {
            temp.append(LINE_PREFIX);
        }
        temp.append("(In)");
        String end = "(eds.);";
        List<Editor> editors = book.getEditors();
        for (int i = 0; i < editors.size(); ++i) {
            String val = editors.get(i).getValue();
            if (temp.length() + val.length() >= 78) {
                lines.add(temp.toString());
                temp = new StringBuilder();
                if (includeFFMarkup) {
                    temp.append(LINE_PREFIX);
                }
            } else {
                temp.append(" ");
            }
            temp.append(val);
            if (i == editors.size() - 1) continue;
            temp.append(",");
        }
        if (!editors.isEmpty()) {
            if (includeFFMarkup && temp.length() + end.length() >= 79) {
                lines.add(temp.toString());
                temp = new StringBuilder();
                if (includeFFMarkup) {
                    temp.append(LINE_PREFIX);
                }
            } else {
                temp.append(" ");
            }
            temp.append(end);
            if (includeFFMarkup) {
                lines.add(temp.toString());
                temp = new StringBuilder();
                temp.append(LINE_PREFIX);
            } else {
                temp.append(" ");
            }
        } else {
            temp.append(" ");
        }
        String bookName = book.getBookName().getValue();
        boolean hasAbstractCommo = this.bookHasAbstractComma(bookName);
        temp.append(bookName);
        boolean bl = hasPages = !book.getVolume().getValue().equals("") || !book.getFirstPage().getValue().equals("") || !book.getLastPage().getValue().equals("");
        if (hasPages && !hasAbstractCommo) {
            if (book.getFirstPage().getValue().toUpperCase().startsWith("ABSTRACT#")) {
                temp.append(", ").append(book.getFirstPage().getValue());
            } else {
                temp.append(", pp.");
                if (!book.getVolume().getValue().equals("")) {
                    temp.append(book.getVolume().getValue());
                    temp.append(":");
                }
                temp.append(book.getFirstPage().getValue());
                temp.append("-");
                temp.append(book.getLastPage().getValue());
            }
        }
        if (book.getPublisher() != null && !book.getPublisher().getValue().equals("")) {
            temp.append(", ");
            temp.append(book.getPublisher().getValue());
        }
        if (book.getCity() != null && !book.getCity().getValue().equals("")) {
            temp.append(", ");
            temp.append(book.getCity().getValue());
        }
        temp.append(" (").append(book.getPublicationDate().getValue()).append(")");
        temp.append(".");
        if (includeFFMarkup) {
            lines.addAll(FFLineWrapper.buildLines(temp.toString(), " ", LINE_PREFIX, 80));
        } else {
            lines.add(temp.toString());
        }
        return lines;
    }

    private boolean bookHasAbstractComma(String title) {
        if (Strings.isNullOrEmpty((String)title)) {
            return false;
        }
        String titleNoCase = title.toLowerCase();
        return titleNoCase.contains(", abstract");
    }
}

