/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.cc;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.line.FFLineWrapper;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.CCLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.WebResourceComment;

public class WebResourceCCLineBuilder
extends CCLineBuilderAbstr<WebResourceComment> {
    @Override
    protected List<String> buildCommentLines(WebResourceComment comment, boolean includeFlatFileMarkings, boolean showEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (includeFlatFileMarkings) {
            this.addFlatFileMarkingsIfRequired(includeFlatFileMarkings, sb);
        }
        sb.append(comment.getCommentType().toDisplayName());
        sb.append(": ");
        this.addMolecule(comment, sb, true);
        sb.append("Name=");
        sb.append(comment.getDatabaseName().getValue());
        sb.append(";");
        if (comment.getDatabaseNote() != null && comment.getDatabaseNote().getValue().length() > 0) {
            sb.append(" ");
            sb.append("Note=");
            sb.append(comment.getDatabaseNote().getValue());
            sb.append(";");
        }
        if (includeFlatFileMarkings) {
            lines.addAll(FFLineWrapper.buildLines(sb, " ", this.linePrefix));
        } else {
            lines.add(sb.toString());
        }
        if (comment.getDatabaseURL() != null && !comment.getDatabaseURL().getValue().equals("")) {
            sb = new StringBuilder();
            if (includeFlatFileMarkings) {
                sb.append(this.linePrefix);
            }
            sb.append("URL=\"");
            sb.append(comment.getDatabaseURL().getValue());
            sb.append("\";");
            lines.add(sb.toString());
        }
        if (comment.getDatabaseFTP() != null && !comment.getDatabaseFTP().getValue().equals("")) {
            sb = new StringBuilder();
            if (includeFlatFileMarkings) {
                sb.append(this.linePrefix);
            }
            sb.append("FTP=\"");
            sb.append(comment.getDatabaseFTP().getValue());
            sb.append("\";");
            lines.add(sb.toString());
        }
        return this.addEvidences(lines, comment, showEvidence, this.linePrefix);
    }
}

