/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.FFLines;
import uk.ac.ebi.kraken.ffwriter.line.impl.FFLineBuilderAbstr;
import uk.ac.ebi.kraken.ffwriter.line.impl.ft.FeatureLineBuilderFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;

public class FTLineBuilder
extends FFLineBuilderAbstr<List<Feature>>
implements FFLineBuilder<List<Feature>> {
    public FTLineBuilder() {
        super(LineType.FT);
    }

    @Override
    public String buildString(List<Feature> features) {
        List<String> lines = this.buildLines(features, false, false);
        return FFLines.create(lines).toString();
    }

    @Override
    public String buildStringWithEvidence(List<Feature> features) {
        List<String> lines = this.buildLines(features, false, true);
        return FFLines.create(lines).toString();
    }

    @Override
    protected FFLine buildLine(List<Feature> f, boolean showEvidence) {
        List<String> lines = this.buildLines(f, true, showEvidence);
        return FFLines.create(lines);
    }

    private List<String> buildLines(List<Feature> features, boolean includeFFMarkings, boolean showEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        for (Feature feature : features) {
            FFLineBuilder<Feature> fbuilder = FeatureLineBuilderFactory.create(feature);
            if (includeFFMarkings) {
                if (showEvidence) {
                    lines.addAll(fbuilder.buildWithEvidence(feature).lines());
                    continue;
                }
                lines.addAll(fbuilder.build(feature).lines());
                continue;
            }
            if (showEvidence) {
                lines.add(fbuilder.buildStringWithEvidence(feature));
                continue;
            }
            lines.add(fbuilder.buildString(feature));
        }
        return lines;
    }
}

