/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.helpers;

import uk.ac.ebi.kraken.ffwriter.line.FFLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.CommentLineBuilderFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;

public class CommentObjectHelper {
    public static <T extends Comment> String export(T comment, boolean includeFlatFileMarkings, boolean showEvidence) {
        FFLineBuilder<T> fbuilder = CommentLineBuilderFactory.create(comment);
        if (showEvidence) {
            if (includeFlatFileMarkings) {
                return fbuilder.buildWithEvidence(comment).toString();
            }
            return fbuilder.buildStringWithEvidence(comment);
        }
        if (includeFlatFileMarkings) {
            return fbuilder.build(comment).toString();
        }
        return fbuilder.buildString(comment);
    }

    public static String getCommentText(Comment comment) {
        String value = CommentObjectHelper.export(comment, false, false);
        int index = value.indexOf(": ");
        if (index != -1) {
            int length = value.length();
            if (value.endsWith(".")) {
                --length;
            }
            value = value.substring(index + 2, length);
        }
        return value;
    }
}

