/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter;

import uk.ac.ebi.kraken.ffwriter.line.impl.KWLineBuilder;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;

public class KWLine {
    private static final KWLineBuilder BUILDER = new KWLineBuilder();

    public static String export(UniProtEntry uniProtEntry) {
        return KWLine.export(uniProtEntry, false);
    }

    public static String export(UniProtEntry uniProtEntry, boolean showEvidence) {
        return KWLine.export(uniProtEntry, showEvidence, true);
    }

    public static String export(UniProtEntry uniProtEntry, boolean showEvidence, boolean includeFFMarkup) {
        int numberTotalKeywords = uniProtEntry.getKeywords().size();
        if (numberTotalKeywords == 0) {
            return "";
        }
        if (includeFFMarkup) {
            if (showEvidence) {
                return BUILDER.buildWithEvidence(uniProtEntry.getKeywords()).toString() + '\n';
            }
            return BUILDER.build(uniProtEntry.getKeywords()).toString() + '\n';
        }
        return BUILDER.buildString(uniProtEntry.getKeywords());
    }
}

