/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLines;
import uk.ac.ebi.kraken.ffwriter.line.impl.GNLineBuilder;
import uk.ac.ebi.kraken.interfaces.uniprot.Gene;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;

public class GNLine {
    private static final GNLineBuilder BUILDER = new GNLineBuilder();

    public static String export(UniProtEntry entry) {
        return GNLine.export(entry, false);
    }

    public static String export(UniProtEntry entry, boolean showEvidence) {
        StringBuilder sb = new StringBuilder();
        int genesCounter = 1;
        for (Gene gene : entry.getGenes()) {
            sb.append(GNLine.export(gene, true, genesCounter, showEvidence));
            ++genesCounter;
        }
        return sb.toString();
    }

    public static String export(Gene gene, boolean includeFFMarkup) {
        return GNLine.export(gene, includeFFMarkup, 1, false);
    }

    private static String export(Gene gene, boolean includeFFMarkup, int geneNumber, boolean showEvidence) {
        ArrayList<Gene> genes = new ArrayList<Gene>();
        genes.add(gene);
        if (includeFFMarkup) {
            FFLine line = null;
            line = showEvidence ? BUILDER.buildWithEvidence(genes) : BUILDER.build(genes);
            if (geneNumber > 1) {
                ArrayList<String> lines = new ArrayList<String>();
                lines.add("GN   and");
                lines.addAll(line.lines());
                return FFLines.create(lines).toString() + '\n';
            }
            return line.toString() + '\n';
        }
        return BUILDER.buildString((List<Gene>)genes);
    }
}

