/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.line.impl.DRLineBuilder;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.internalsection.InternalLine;
import uk.ac.ebi.kraken.interfaces.uniprot.internalsection.InternalLineType;
import uk.ac.ebi.kraken.model.uniprot.dbx.CrossReferenceDatabaseContext;

public class DRLine {
    private static final DRLineBuilder BUILDER = new DRLineBuilder();

    public static String export(UniProtEntry entry, boolean includeFFMarkings) {
        return DRLine.export(entry, includeFFMarkings, false);
    }

    public static String export(UniProtEntry entry, boolean includeFFMarkings, boolean showEvidence) {
        StringBuilder sb = new StringBuilder();
        for (String databaseType : CrossReferenceDatabaseContext.INSTANCE.getAllXrefDBName()) {
            List<DatabaseCrossReference> listDBXref = entry.getDatabaseCrossReferences(databaseType);
            for (DatabaseCrossReference databaseCrossReference : listDBXref) {
                sb.append(DRLine.export(databaseCrossReference, includeFFMarkings, showEvidence));
            }
        }
        for (InternalLine line : entry.getInternalSection().getInternalLines()) {
            if (InternalLineType.PROSITE != line.getInternalLineType()) continue;
            sb.append("**   ");
            sb.append((Object)line.getInternalLineType());
            sb.append("; ");
            sb.append(line.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String export(DatabaseCrossReference reference, boolean includeFFMarkings) {
        return DRLine.export(reference, includeFFMarkings, false);
    }

    public static String export(DatabaseCrossReference reference, boolean includeFFMarkings, boolean showEvidence) {
        ArrayList<DatabaseCrossReference> xrefs = new ArrayList<DatabaseCrossReference>();
        xrefs.add(reference);
        if (includeFFMarkings) {
            if (showEvidence) {
                return BUILDER.buildWithEvidence(xrefs).toString() + "\n";
            }
            return BUILDER.build(xrefs).toString() + "\n";
        }
        return BUILDER.buildString((Collection<DatabaseCrossReference>)xrefs);
    }
}

