/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter;

import java.util.List;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.FFLines;
import uk.ac.ebi.kraken.ffwriter.line.impl.CCLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.CommentLineBuilderFactory;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.SequenceCautionCCLineBuilder;
import uk.ac.ebi.kraken.interfaces.uniprot.CommentStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionComment;

public class CCLine {
    private static final boolean DO_INCLUDE_FF_MARKINGS = true;
    private static final boolean DONT_SHOW_EVIDENCE = false;
    private static final CCLineBuilder LINE_BUILDER = new CCLineBuilder();

    public static String export(Comment comment) {
        return CCLine.export(comment, true);
    }

    public static String export(Comment comment, boolean includeFFMarkings) {
        return CCLine.export(comment, includeFFMarkings, false);
    }

    public static String export(Comment comment, boolean includeFFMarkings, boolean showEvidence) {
        return CCLine.export(comment, includeFFMarkings, showEvidence, true);
    }

    public static String exportWithNoStatus(Comment comment) {
        return CCLine.exportWithNoStatus(comment, true);
    }

    public static String exportWithNoStatus(Comment comment, boolean includeFFMarkings) {
        String commentWithNoStatus = CCLine.export(comment, includeFFMarkings, false, true);
        for (CommentStatus commentStatus : CommentStatus.values()) {
            String commentStatusValue = commentStatus.getValue();
            commentWithNoStatus = commentWithNoStatus.replaceAll("\\(" + commentStatusValue + "\\)", "");
        }
        return commentWithNoStatus;
    }

    private static String export(Comment comment, boolean includeFFMarkings, boolean showEvidence, boolean isFirstSequenceCaution) {
        if (comment instanceof SequenceCautionComment) {
            FFLineBuilder<SequenceCautionComment> builder2 = CommentLineBuilderFactory.create((SequenceCautionComment)comment);
            SequenceCautionCCLineBuilder scBuilder = (SequenceCautionCCLineBuilder)builder2;
            scBuilder.setIsFirstSequenceCaution(isFirstSequenceCaution);
        }
        FFLineBuilder<Comment> builder = CommentLineBuilderFactory.create(comment);
        if (includeFFMarkings) {
            if (showEvidence) {
                return builder.buildWithEvidence(comment).toString();
            }
            return builder.build(comment).toString();
        }
        return builder.buildString(comment);
    }

    public static String export(UniProtEntry uniProtEntry) {
        return CCLine.export(uniProtEntry, false);
    }

    public static String export(UniProtEntry entry, boolean showEvidence) {
        if (entry.getComments().isEmpty()) {
            return "";
        }
        FFLine ccLines = FFLines.create();
        for (CommentType commentType : CommentType.values()) {
            List comments = entry.getComments(commentType);
            if (comments.isEmpty()) continue;
            if (showEvidence) {
                ccLines.add(LINE_BUILDER.buildWithEvidence(comments));
                continue;
            }
            ccLines.add(LINE_BUILDER.build(comments));
        }
        return ccLines.toString() + '\n';
    }
}

