/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import javax.servlet.RequestDispatcher;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.SessionHandler;
import org.mortbay.log.Log;
import org.mortbay.util.URIUtil;

public class Context
extends ContextHandler {
    public static final int SESSIONS = 1;
    public static final int SECURITY = 2;
    public static final int NO_SESSIONS = 0;
    public static final int NO_SECURITY = 0;
    protected SecurityHandler _securityHandler;
    protected ServletHandler _servletHandler;
    protected SessionHandler _sessionHandler;

    public Context() {
        this(null, null, null, null, null);
    }

    public Context(int options) {
        this(null, null, options);
    }

    public Context(HandlerContainer parent, String contextPath) {
        this(parent, contextPath, null, null, null, null);
    }

    public Context(HandlerContainer parent, String contextPath, int options) {
        this(parent, contextPath, (options & 1) != 0 ? new SessionHandler() : null, (options & 2) != 0 ? new SecurityHandler() : null, null, null);
    }

    public Context(HandlerContainer parent, String contextPath, boolean sessions, boolean security) {
        this(parent, contextPath, (sessions ? 1 : 0) | (security ? 2 : 0));
    }

    public Context(HandlerContainer parent, SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler) {
        this(parent, null, sessionHandler, securityHandler, servletHandler, errorHandler);
    }

    public Context(HandlerContainer parent, String contextPath, SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler) {
        super((ContextHandler.SContext)null);
        this._scontext = new SContext();
        this._sessionHandler = sessionHandler;
        this._securityHandler = securityHandler;
        ServletHandler servletHandler2 = this._servletHandler = servletHandler != null ? servletHandler : new ServletHandler();
        if (this._sessionHandler != null) {
            this.setHandler(this._sessionHandler);
            if (securityHandler != null) {
                this._sessionHandler.setHandler(this._securityHandler);
                this._securityHandler.setHandler(this._servletHandler);
            } else {
                this._sessionHandler.setHandler(this._servletHandler);
            }
        } else if (this._securityHandler != null) {
            this.setHandler(this._securityHandler);
            this._securityHandler.setHandler(this._servletHandler);
        } else {
            this.setHandler(this._servletHandler);
        }
        if (errorHandler != null) {
            this.setErrorHandler(errorHandler);
        }
        if (contextPath != null) {
            this.setContextPath(contextPath);
        }
        if (parent != null) {
            parent.addHandler(this);
        }
    }

    protected void startContext() throws Exception {
        super.startContext();
        if (this._servletHandler != null && this._servletHandler.isStarted()) {
            this._servletHandler.initialize();
        }
    }

    public SecurityHandler getSecurityHandler() {
        return this._securityHandler;
    }

    public ServletHandler getServletHandler() {
        return this._servletHandler;
    }

    public SessionHandler getSessionHandler() {
        return this._sessionHandler;
    }

    public ServletHolder addServlet(String className, String pathSpec) {
        return this._servletHandler.addServletWithMapping(className, pathSpec);
    }

    public ServletHolder addServlet(Class servlet, String pathSpec) {
        return this._servletHandler.addServletWithMapping(servlet.getName(), pathSpec);
    }

    public void addServlet(ServletHolder servlet, String pathSpec) {
        this._servletHandler.addServletWithMapping(servlet, pathSpec);
    }

    public void addFilter(FilterHolder holder, String pathSpec, int dispatches) {
        this._servletHandler.addFilterWithMapping(holder, pathSpec, dispatches);
    }

    public FilterHolder addFilter(Class filterClass, String pathSpec, int dispatches) {
        return this._servletHandler.addFilterWithMapping(filterClass, pathSpec, dispatches);
    }

    public FilterHolder addFilter(String filterClass, String pathSpec, int dispatches) {
        return this._servletHandler.addFilterWithMapping(filterClass, pathSpec, dispatches);
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        if (this._sessionHandler == sessionHandler) {
            return;
        }
        if (this._sessionHandler != null) {
            this._sessionHandler.setHandler(null);
        }
        this._sessionHandler = sessionHandler;
        this.setHandler(this._sessionHandler);
        if (this._securityHandler != null) {
            this._sessionHandler.setHandler(this._securityHandler);
        } else if (this._servletHandler != null) {
            this._sessionHandler.setHandler(this._servletHandler);
        }
    }

    public void setSecurityHandler(SecurityHandler securityHandler) {
        if (this._securityHandler == securityHandler) {
            return;
        }
        if (this._securityHandler != null) {
            this._securityHandler.setHandler(null);
        }
        this._securityHandler = securityHandler;
        if (this._securityHandler == null) {
            if (this._sessionHandler != null) {
                this._sessionHandler.setHandler(this._servletHandler);
            } else {
                this.setHandler(this._servletHandler);
            }
        } else {
            if (this._sessionHandler != null) {
                this._sessionHandler.setHandler(this._securityHandler);
            } else {
                this.setHandler(this._securityHandler);
            }
            if (this._servletHandler != null) {
                this._securityHandler.setHandler(this._servletHandler);
            }
        }
    }

    public void setServletHandler(ServletHandler servletHandler) {
        if (this._servletHandler == servletHandler) {
            return;
        }
        this._servletHandler = servletHandler;
        if (this._securityHandler != null) {
            this._securityHandler.setHandler(this._servletHandler);
        } else if (this._sessionHandler != null) {
            this._sessionHandler.setHandler(this._servletHandler);
        } else {
            this.setHandler(this._servletHandler);
        }
    }

    public class SContext
    extends ContextHandler.SContext {
        public SContext() {
            super(Context.this);
        }

        public RequestDispatcher getNamedDispatcher(String name) {
            Context context = Context.this;
            if (Context.this._servletHandler == null || Context.this._servletHandler.getServlet(name) == null) {
                return null;
            }
            return new Dispatcher(context, name);
        }

        public RequestDispatcher getRequestDispatcher(String uriInContext) {
            if (uriInContext == null) {
                return null;
            }
            if (!uriInContext.startsWith("/")) {
                return null;
            }
            try {
                String query = null;
                int q = 0;
                q = uriInContext.indexOf(63);
                if (q > 0) {
                    query = uriInContext.substring(q + 1);
                    uriInContext = uriInContext.substring(0, q);
                }
                if ((q = uriInContext.indexOf(59)) > 0) {
                    uriInContext = uriInContext.substring(0, q);
                }
                String pathInContext = URIUtil.canonicalPath((String)URIUtil.decodePath((String)uriInContext));
                String uri = URIUtil.addPaths((String)this.getContextPath(), (String)uriInContext);
                Context context = Context.this;
                return new Dispatcher(context, uri, pathInContext, query);
            }
            catch (Exception e) {
                Log.ignore((Throwable)e);
                return null;
            }
        }
    }
}

