/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.prosplign.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import org.sing_group.gc4s.event.RunnableDocumentAdapter;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanel;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanelBuilder;
import org.sing_group.gc4s.input.filechooser.SelectionMode;
import org.sing_group.gc4s.input.text.JIntegerTextField;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.blast.execution.BlastBinariesExecutor;
import org.sing_group.seda.blast.gui.BlastExecutionConfigurationPanel;
import org.sing_group.seda.gui.CommonFileChooser;
import org.sing_group.seda.gui.execution.BinaryExecutionConfigurationPanel;
import org.sing_group.seda.prosplign.execution.ProSplignCompartBinariesExecutor;
import org.sing_group.seda.prosplign.gui.ProSplignCompartExecutionConfigurationPanel;
import org.sing_group.seda.prosplign.transformation.provider.ProSplignCompartPipelineTransformationProvider;

public class ProSplignCompartPipelineTransformationConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JFileChooserPanel proteinFileQuery;
    private JIntegerTextField maxTargetSeqs;
    private ProSplignCompartExecutionConfigurationPanel proSplignCompartExecutionConfigurationPanel;
    private BlastExecutionConfigurationPanel blastExecutionConfigurationPanel;
    private ProSplignCompartPipelineTransformationProvider transformationProvider;

    public ProSplignCompartPipelineTransformationConfigurationPanel() {
        this.init();
        this.initTransformationProvider();
    }

    private void initTransformationProvider() {
        this.transformationProvider = new ProSplignCompartPipelineTransformationProvider();
        this.proSplignCompartExecutorChanged();
        this.blastExecutorChanged();
        this.proteinFileQueryChanged();
        this.maxTargetSeqsChanged();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add((Component)this.getQueryConfigurationPanel());
        return new CenteredJPanel((Component)mainPanel);
    }

    private InputParametersPanel getQueryConfigurationPanel() {
        InputParametersPanel queryConfigurationPanel = new InputParametersPanel(this.getParameters());
        return queryConfigurationPanel;
    }

    private InputParameter[] getParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getProSplignCompartExecutableParameter());
        parameters.add(this.getBlastExecutableParameter());
        parameters.add(this.getProteinQueryFileParameter());
        parameters.add(this.getMaxTargetSeqsParameter());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getProSplignCompartExecutableParameter() {
        this.proSplignCompartExecutionConfigurationPanel = new ProSplignCompartExecutionConfigurationPanel(this::proSplignCompartExecutorChanged);
        return new InputParameter("", (JComponent)this.proSplignCompartExecutionConfigurationPanel, "The mode to execute ProSplign/ProCompart.");
    }

    private void proSplignCompartExecutorChanged(BinaryExecutionConfigurationPanel<ProSplignCompartBinariesExecutor> source) {
        this.proSplignCompartExecutorChanged();
    }

    private void proSplignCompartExecutorChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setProSplignCompartBinariresExecutor(this.proSplignCompartExecutionConfigurationPanel.getBinariesExecutor()));
    }

    private InputParameter getBlastExecutableParameter() {
        this.blastExecutionConfigurationPanel = new BlastExecutionConfigurationPanel(this::blastExecutorChanged);
        this.blastExecutionConfigurationPanel.setBorder((Border)BorderFactory.createTitledBorder("BLAST configuration"));
        return new InputParameter("", (JComponent)this.blastExecutionConfigurationPanel, "The mode to execute BLAST.");
    }

    private void blastExecutorChanged(BinaryExecutionConfigurationPanel<BlastBinariesExecutor> source) {
        this.blastExecutorChanged();
    }

    private void blastExecutorChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setBlastBinariesExecutor(this.blastExecutionConfigurationPanel.getBinariesExecutor()));
    }

    private InputParameter getProteinQueryFileParameter() {
        this.proteinFileQuery = JFileChooserPanelBuilder.createOpenJFileChooserPanel().withFileChooser(CommonFileChooser.getInstance().getFilechooser()).withFileChooserSelectionMode(SelectionMode.FILES).withLabel("").withClearSelectedFileOnShow(true).build();
        this.proteinFileQuery.addFileChooserListener(e -> this.proteinFileQueryChanged());
        return new InputParameter("External file query:", (JComponent)this.proteinFileQuery, "The query file (proteins).");
    }

    private void proteinFileQueryChanged() {
        SwingUtilities.invokeLater(() -> {
            File file = this.proteinFileQuery.getSelectedFile();
            if (file != null) {
                this.transformationProvider.setProteinQueryFile(file);
            } else {
                this.transformationProvider.clearProteinQueryFile();
            }
        });
    }

    private InputParameter getMaxTargetSeqsParameter() {
        this.maxTargetSeqs = new JIntegerTextField(Integer.valueOf(1));
        this.maxTargetSeqs.setColumns(4);
        this.maxTargetSeqs.getDocument().addDocumentListener((DocumentListener)new RunnableDocumentAdapter(this::maxTargetSeqsChanged));
        return new InputParameter("Max. target seqs.:", (JComponent)this.maxTargetSeqs, "Value of the max_target_seqs BLAST parameter.");
    }

    private void maxTargetSeqsChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setMaxTargetSeqs(this.maxTargetSeqs.getValue()));
    }

    public ProSplignCompartPipelineTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(ProSplignCompartPipelineTransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
        if (this.transformationProvider.getProteinQueryFile() != null) {
            this.proteinFileQuery.setSelectedFile(this.transformationProvider.getProteinQueryFile());
        } else {
            this.proteinFileQuery.clearSelectedFile();
        }
        this.maxTargetSeqs.setValue((Object)this.transformationProvider.getMaxTargetSeqs());
        if (this.transformationProvider.getProSplignCompartBinariesExecutor() != null) {
            this.proSplignCompartExecutionConfigurationPanel.setBinariesExecutor(this.transformationProvider.getProSplignCompartBinariesExecutor());
        }
        if (this.transformationProvider.getBlastBinariesExecutor() != null) {
            this.blastExecutionConfigurationPanel.setBinariesExecutor(this.transformationProvider.getBlastBinariesExecutor());
        }
    }
}

