/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.plugin.gui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import org.sing_group.seda.blast.gui.TwoWayBlastTransformationConfigurationPanel;
import org.sing_group.seda.blast.plugin.core.TwoWayBlastSedaPluginInfo;
import org.sing_group.seda.blast.transformation.provider.twowayblast.TwoWayBlastTransformationProvider;
import org.sing_group.seda.core.SedaContext;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.core.io.JsonObjectWriter;
import org.sing_group.seda.plugin.core.gui.AbstractSedaGuiPlugin;
import org.sing_group.seda.plugin.spi.TransformationProvider;

public class TwoWayBlastSedaGuiPlugin
extends AbstractSedaGuiPlugin {
    private TwoWayBlastTransformationConfigurationPanel blastConfigurationPanel = new TwoWayBlastTransformationConfigurationPanel();

    @Override
    public String getName() {
        return "BLAST: two-way ortholog identification";
    }

    @Override
    public String getGroupName() {
        return TwoWayBlastSedaPluginInfo.GROUP;
    }

    @Override
    public String getDescription() {
        return "Find sequence orthologs in a set of FASTA files using the Reciprocal Best Hits method.";
    }

    @Override
    public Component getEditor() {
        return this.blastConfigurationPanel;
    }

    @Override
    public TransformationProvider getTransformation() {
        return this.blastConfigurationPanel.getTransformationProvider();
    }

    @Override
    public void setSedaContext(SedaContext context) {
        super.setSedaContext(context);
        this.blastConfigurationPanel.setSedaContext(context);
    }

    @Override
    public boolean canSaveTransformation() {
        return true;
    }

    @Override
    public void saveTransformation(File file) throws IOException {
        new JsonObjectWriter<TwoWayBlastTransformationProvider>().write(this.blastConfigurationPanel.getTransformationProvider(), file);
    }

    @Override
    public void loadTransformation(File file) throws IOException {
        this.blastConfigurationPanel.setTransformationProvider((TwoWayBlastTransformationProvider)new JsonObjectReader().read(file, TwoWayBlastTransformationProvider.class));
    }
}

