/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.plugin.gui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import org.sing_group.seda.blast.gui.BlastTransformationConfigurationPanel;
import org.sing_group.seda.blast.plugin.core.BlastSedaPluginInfo;
import org.sing_group.seda.blast.transformation.provider.blast.BlastTransformationProvider;
import org.sing_group.seda.core.SedaContext;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.core.io.JsonObjectWriter;
import org.sing_group.seda.plugin.core.gui.AbstractSedaGuiPlugin;
import org.sing_group.seda.plugin.spi.TransformationProvider;

public class BlastSedaGuiPlugin
extends AbstractSedaGuiPlugin {
    private BlastTransformationConfigurationPanel blastConfigurationPanel = new BlastTransformationConfigurationPanel();

    @Override
    public String getName() {
        return "BLAST";
    }

    @Override
    public String getGroupName() {
        return BlastSedaPluginInfo.GROUP;
    }

    @Override
    public String getDescription() {
        return "Perform BLAST queries using the selected FASTA files as a single or mutiple independent database(s).";
    }

    @Override
    public Component getEditor() {
        return this.blastConfigurationPanel;
    }

    @Override
    public TransformationProvider getTransformation() {
        return this.blastConfigurationPanel.getTransformationProvider();
    }

    @Override
    public void setSedaContext(SedaContext context) {
        super.setSedaContext(context);
        this.blastConfigurationPanel.setSedaContext(context);
    }

    @Override
    public boolean canSaveTransformation() {
        return true;
    }

    @Override
    public void saveTransformation(File file) throws IOException {
        new JsonObjectWriter<BlastTransformationProvider>().write(this.blastConfigurationPanel.getTransformationProvider(), file);
    }

    @Override
    public void loadTransformation(File file) throws IOException {
        this.blastConfigurationPanel.setTransformationProvider((BlastTransformationProvider)new JsonObjectReader().read(file, BlastTransformationProvider.class));
    }
}

