/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.ncbi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.sing_group.seda.blast.ncbi.NcbiBlastHit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class NcbiBlastHits
extends LinkedList<NcbiBlastHit> {
    private static final long serialVersionUID = 1L;

    public static final NcbiBlastHits fromXml(String xml) throws SAXException, IOException {
        NcbiBlastHits toret = new NcbiBlastHits();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(xml.getBytes()));
            Element root = document.getDocumentElement();
            NodeList hits = root.getElementsByTagName("Hit");
            for (int temp = 0; temp < hits.getLength(); ++temp) {
                Node nNode = hits.item(temp);
                if (nNode.getNodeType() != 1) continue;
                Element eElement = (Element)nNode;
                String accession = eElement.getElementsByTagName("Hit_accession").item(0).getTextContent();
                String description = eElement.getElementsByTagName("Hit_def").item(0).getTextContent();
                Node hitHsps = eElement.getElementsByTagName("Hit_hsps").item(0);
                if (hitHsps.getNodeType() != 1) continue;
                NodeList hsps = ((Element)hitHsps).getElementsByTagName("Hsp");
                LinkedList<String> hspHseqs = new LinkedList<String>();
                for (int i = 0; i < hsps.getLength(); ++i) {
                    Node hsp = hsps.item(i);
                    if (hsp.getNodeType() != 1) continue;
                    Node hspHseq = ((Element)hsp).getElementsByTagName("Hsp_hseq").item(0);
                    hspHseqs.add(hspHseq.getTextContent());
                }
                toret.add(new NcbiBlastHit(accession, description, hspHseqs));
            }
            return toret;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

