/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.ncbi;

import org.sing_group.seda.blast.datatype.SequenceType;

public enum NcbiBlastDatabase {
    NT("nt", "Nucleotide collection", SequenceType.NUCLEOTIDES),
    NR("nr", "Non-redundant", SequenceType.PROTEINS),
    REFSEQ_RNA("refseq_rna", "NCBI Transcript Reference Sequences ", SequenceType.NUCLEOTIDES),
    REFSEQ_PROTEIN("refseq_protein", "NCBI Protein Reference Sequences", SequenceType.PROTEINS),
    SWISSPROT("swissprot", "Non-redundant UniProtKB/SwissProt sequences", SequenceType.PROTEINS),
    PDBAA("pdbaa", "PDB protein database", SequenceType.PROTEINS),
    PDBNT("pdbnt", "PDB nucleotide database", SequenceType.NUCLEOTIDES);

    private String name;
    private String title;
    private SequenceType sequenceType;

    private NcbiBlastDatabase(String name, String title, SequenceType sequenceType) {
        this.name = name;
        this.title = title;
        this.sequenceType = sequenceType;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public SequenceType getSequenceType() {
        return this.sequenceType;
    }

    public String toString() {
        return this.title;
    }
}

