/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.execution;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.sing_group.seda.blast.datatype.blast.BlastType;
import org.sing_group.seda.blast.execution.BlastBinariesChecker;
import org.sing_group.seda.blast.execution.BlastBinariesExecutor;
import org.sing_group.seda.core.execution.AbstractBinariesExecutor;
import org.sing_group.seda.core.execution.BinaryCheckException;

public abstract class AbstractBlastBinariesExecutor
extends AbstractBinariesExecutor
implements BlastBinariesExecutor {
    @Override
    public void checkBinary() throws BinaryCheckException {
        BlastBinariesChecker.checkBlastPath(this::composeBlastCommand);
    }

    protected abstract String composeBlastCommand(String var1);

    protected abstract String toFilePath(File var1);

    public void blastDbCmd(List<String> blastCommand, File aliasFile, File entryBatchFile, File outFile) throws IOException, InterruptedException {
        LinkedList<String> parameters = new LinkedList<String>(blastCommand);
        parameters.addAll(Arrays.asList("-db", this.toFilePath(aliasFile), "-entry_batch", this.toFilePath(entryBatchFile), "-out", this.toFilePath(outFile)));
        this.executeCommand(parameters);
    }

    public void blastDbCmd(List<String> blastCommand, File aliasFile, String subjectSequenceID, String range, File outFile) throws IOException, InterruptedException {
        LinkedList<String> parameters = new LinkedList<String>(blastCommand);
        parameters.addAll(Arrays.asList("-db", this.toFilePath(aliasFile), "-entry", subjectSequenceID, "-range", range, "-out", this.toFilePath(outFile)));
        this.executeCommand(parameters);
    }

    public void blastDbCmd(List<String> blastCommand, File aliasFile, String subjectSequenceID, File outFile) throws IOException, InterruptedException {
        LinkedList<String> parameters = new LinkedList<String>(blastCommand);
        parameters.addAll(Arrays.asList("-db", this.toFilePath(aliasFile), "-entry", subjectSequenceID, "-out", this.toFilePath(outFile)));
        this.executeCommand(parameters);
    }

    public void makeBlastDb(List<String> blastCommand, File inFile, String blastSequenceType, File dbFile, boolean parseSeqIds) throws IOException, InterruptedException {
        LinkedList<String> parameters = new LinkedList<String>(blastCommand);
        parameters.addAll(Arrays.asList("-in", this.toFilePath(inFile), "-dbtype", blastSequenceType, "-out", this.toFilePath(dbFile)));
        if (parseSeqIds) {
            parameters.add("-parse_seqids");
        }
        this.executeCommand(parameters);
    }

    public void makeDbAlias(List<String> blastCommand, List<File> blastDatabases, String blastSequenceType, File outFile, String dbAliasTitle) throws IOException, InterruptedException {
        LinkedList<String> parameters = new LinkedList<String>(blastCommand);
        parameters.addAll(Arrays.asList("-dblist", blastDatabases.stream().map(this::toFilePath).collect(Collectors.joining(" ")), "-dbtype", blastSequenceType, "-out", this.toFilePath(outFile), "-title", dbAliasTitle));
        this.executeCommand(parameters);
    }

    public void executeBlast(List<String> blastCommand, BlastType blastType, File queryFile, File database, double expectedValue, int maxTargetSeqs, File outFile, String outFormat, List<String> additionalBlastParameters) throws IOException, InterruptedException {
        LinkedList<String> parameters = new LinkedList<String>(blastCommand);
        parameters.addAll(Arrays.asList("-query", this.toFilePath(queryFile), "-db", this.toFilePath(database), "-evalue", String.valueOf(expectedValue), "-max_target_seqs", String.valueOf(maxTargetSeqs), "-out", this.toFilePath(outFile), "-outfmt", outFormat));
        if (!additionalBlastParameters.isEmpty()) {
            parameters.addAll(additionalBlastParameters);
        }
        this.executeCommand(parameters);
    }
}

