/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.utilities;

import java.awt.Color;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;

public class Gradient {
    public static Color[] createGradient(Color colorFrom, Color colorTo, int numSteps) {
        if (numSteps < 1) {
            throw new IllegalArgumentException("numSteps must be higher than 0");
        }
        if (numSteps == 1) {
            return new Color[]{colorFrom};
        }
        Function<ToIntFunction, IntUnaryOperator> interpolationBuilder = getPrimary -> {
            int primaryFrom = getPrimary.applyAsInt(colorFrom);
            int primaryTo = getPrimary.applyAsInt(colorTo);
            int distance = primaryTo - primaryFrom;
            return step -> (int)((double)primaryFrom + (double)step / (double)(numSteps - 1) * (double)distance);
        };
        IntUnaryOperator redInterpolation = interpolationBuilder.apply(Color::getRed);
        IntUnaryOperator greenInterpolation = interpolationBuilder.apply(Color::getGreen);
        IntUnaryOperator blueInterpolation = interpolationBuilder.apply(Color::getBlue);
        IntUnaryOperator alphaInterpolation = interpolationBuilder.apply(Color::getAlpha);
        IntFunction<Color> colorInterpolator = step -> new Color(redInterpolation.applyAsInt(step), greenInterpolation.applyAsInt(step), blueInterpolation.applyAsInt(step), alphaInterpolation.applyAsInt(step));
        return (Color[])IntStream.range(0, numSteps).mapToObj(colorInterpolator).toArray(Color[]::new);
    }
}

