/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.emboss.execution;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.core.execution.DockerExecutionUtils;
import org.sing_group.seda.core.execution.DockerImageChecker;
import org.sing_group.seda.emboss.execution.AbstractEmbossBinariesExecutor;
import org.sing_group.seda.emboss.execution.EmbossEnvironment;

@XmlRootElement
public class DockerEmbossBinariesExecutor
extends AbstractEmbossBinariesExecutor {
    @XmlTransient
    private final EmbossEnvironment emboss = EmbossEnvironment.getInstance();
    @XmlTransient
    private final DockerImageChecker dockerImageChecker = DockerImageChecker.getInstance();
    @XmlElement
    private final String dockerImage;

    public DockerEmbossBinariesExecutor() {
        this(DockerEmbossBinariesExecutor.getDefaultDockerImage());
    }

    public DockerEmbossBinariesExecutor(String dockerImage) {
        this.dockerImage = dockerImage;
    }

    @Override
    public void getOrf(File input, File output, int table, int minSize, int maxSize, int find, String additionalEmbossParameters) throws IOException, InterruptedException {
        HashSet<String> directoriesToMount = new HashSet<String>();
        directoriesToMount.add(input.getParent());
        directoriesToMount.add(output.getParent());
        super.getOrf(this.composeEmbossCommand(this.dockerImage, directoriesToMount, this.emboss.getOrfCommand()), input, output, table, minSize, maxSize, find, additionalEmbossParameters);
    }

    public static String getDefaultDockerImage() {
        return "singgroup/seda-emboss";
    }

    @Override
    public void checkBinary() throws BinaryCheckException {
        if (this.dockerImageChecker.shouldCheckDockerImage(this.dockerImage)) {
            DockerExecutionUtils.checkDockerAvailability();
            super.checkBinary();
            this.dockerImageChecker.storeImageTimestamp(this.dockerImage);
        }
    }

    @Override
    protected String composeEmbossCommand(String command) {
        return this.composeEmbossCommand(this.dockerImage, command);
    }

    @Override
    protected String toFilePath(File file) {
        return DockerExecutionUtils.dockerPath(file.getAbsolutePath());
    }

    private List<String> composeEmbossCommand(String embossImage, Set<String> directoriesToMount, String command) {
        return Arrays.asList(("docker run --rm " + DockerExecutionUtils.getMountDockerDirectoriesString(directoriesToMount) + " " + embossImage + " " + command).split(" "));
    }

    private String composeEmbossCommand(String embossImage, String command) {
        return "docker run --rm " + embossImage + " " + command;
    }

    public String getDockerImage() {
        return this.dockerImage;
    }
}

