/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.provider.isoforms;

import java.io.File;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.core.filtering.RegexHeaderMatcher;
import org.sing_group.seda.core.operations.DefaultSequenceIsoformSelector;
import org.sing_group.seda.core.operations.SequenceIsoformSelector;
import org.sing_group.seda.core.rename.EmptySequenceHeadersJoiner;
import org.sing_group.seda.core.rename.SequenceHeadersJoiner;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.plugin.spi.AbstractTransformationProvider;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.transformation.dataset.ComposedSequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.provider.isoforms.RemoveIsoformsChangeType;
import org.sing_group.seda.transformation.sequencesgroup.RemoveIsoformsSequencesGroupTransformation;

@XmlRootElement
public class RemoveIsoformsTransformationProvider
extends AbstractTransformationProvider {
    @XmlElement
    private int minimumWordLengh = 250;
    @XmlAnyElement(lax=true)
    private SequenceIsoformSelector selector;
    @XmlElement
    private RegexHeaderMatcher regexHeaderMatcher;
    @XmlElement
    private SequenceHeadersJoiner sequenceHeadersJoiner;
    @XmlElement
    private File removedIsoformsFilesDirectory = null;

    public RemoveIsoformsTransformationProvider() {
        this(new EmptySequenceHeadersJoiner());
    }

    public RemoveIsoformsTransformationProvider(SequenceHeadersJoiner sequenceHeadersJoiner) {
        this.sequenceHeadersJoiner = sequenceHeadersJoiner;
    }

    @Override
    public Validation validate() {
        return this.selector != null ? new DefaultValidation(new String[0]) : new DefaultValidation("The isoform selector is not defined");
    }

    @Override
    public SequencesGroupDatasetTransformation getTransformation(DatatypeFactory factory) {
        RemoveIsoformsSequencesGroupTransformation groupTransformation = null;
        RegexHeaderMatcher headerMatcher = this.getRegexHeaderMatcher();
        groupTransformation = headerMatcher == null ? new RemoveIsoformsSequencesGroupTransformation(factory, this.getRemoveIsoformsTransformationConfiguration(), this.getSelector(), this.getSequenceHeadersJoiner()) : new RemoveIsoformsSequencesGroupTransformation(factory, headerMatcher, this.getRemoveIsoformsTransformationConfiguration(), this.getSelector(), this.getSequenceHeadersJoiner());
        return new ComposedSequencesGroupDatasetTransformation(groupTransformation);
    }

    private RemoveIsoformsSequencesGroupTransformation.RemoveIsoformsTransformationConfiguration getRemoveIsoformsTransformationConfiguration() {
        if (this.removedIsoformsFilesDirectory == null) {
            return new RemoveIsoformsSequencesGroupTransformation.RemoveIsoformsTransformationConfiguration(this.getMinimumWordLengh());
        }
        return new RemoveIsoformsSequencesGroupTransformation.RemoveIsoformsTransformationConfiguration(this.getMinimumWordLengh(), this.removedIsoformsFilesDirectory);
    }

    public int getMinimumWordLengh() {
        return this.minimumWordLengh;
    }

    public void setMinimumWordLength(int minimumWordLengh) {
        if (this.minimumWordLengh != minimumWordLengh) {
            this.minimumWordLengh = minimumWordLengh;
            this.fireTransformationsConfigurationModelEvent(RemoveIsoformsChangeType.MINIMUM_ISOFORM_WORD_LENGTH_CHANGED, this.minimumWordLengh);
        }
    }

    public SequenceIsoformSelector getSelector() {
        return this.selector;
    }

    public void setIsoformSelector(DefaultSequenceIsoformSelector selector) {
        if (this.selector == null || this.selector != selector) {
            this.selector = selector;
            this.fireTransformationsConfigurationModelEvent(RemoveIsoformsChangeType.ISOFORM_SELECTOR_CHANGED, this.selector);
        }
    }

    public void setHeaderMatcher(RegexHeaderMatcher newRegexHeaderMatcher) {
        if (this.regexHeaderMatcher == null || this.regexHeaderMatcher != newRegexHeaderMatcher) {
            this.regexHeaderMatcher = newRegexHeaderMatcher;
            this.fireTransformationsConfigurationModelEvent(RemoveIsoformsChangeType.HEADER_MATCHER_CHANGED, this.regexHeaderMatcher);
        }
    }

    public void removeHeaderMatcher() {
        this.regexHeaderMatcher = null;
        this.fireTransformationsConfigurationModelEvent(RemoveIsoformsChangeType.HEADER_MATCHER_CHANGED, this.regexHeaderMatcher);
    }

    public RegexHeaderMatcher getRegexHeaderMatcher() {
        return this.regexHeaderMatcher;
    }

    public void setRemovedIsoformFilesDirectory(File newRemovedIsoformsFilesDirectory) {
        if (this.removedIsoformsFilesDirectory == null || this.removedIsoformsFilesDirectory != null && !this.removedIsoformsFilesDirectory.equals(newRemovedIsoformsFilesDirectory)) {
            this.removedIsoformsFilesDirectory = newRemovedIsoformsFilesDirectory;
            this.fireTransformationsConfigurationModelEvent(RemoveIsoformsChangeType.REMOVED_ISOFORMS_FILES_DIRECTORY_CHANGED, this.removedIsoformsFilesDirectory);
        }
    }

    public File getRemovedIsoformsFilesDirectory() {
        return this.removedIsoformsFilesDirectory;
    }

    public void clearRemovedIsoformFilesDirectory() {
        this.removedIsoformsFilesDirectory = null;
        this.fireTransformationsConfigurationModelEvent(RemoveIsoformsChangeType.REMOVED_ISOFORMS_FILES_DIRECTORY_CHANGED, this.removedIsoformsFilesDirectory);
    }

    public SequenceHeadersJoiner getSequenceHeadersJoiner() {
        return this.sequenceHeadersJoiner;
    }

    public void setSequenceHeaderJoiner(SequenceHeadersJoiner sequenceHeaderSJoiner) {
        if (this.sequenceHeadersJoiner == null || this.sequenceHeadersJoiner != sequenceHeaderSJoiner) {
            this.sequenceHeadersJoiner = sequenceHeaderSJoiner;
            this.fireTransformationsConfigurationModelEvent(RemoveIsoformsChangeType.SEQUENCE_HEADERS_JOINER_CHANGED, this.sequenceHeadersJoiner);
        }
    }
}

