/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.dataset;

import java.util.LinkedList;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupBuilder;
import org.sing_group.seda.datatype.SequencesGroupDataset;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;

public class MergeSequencesGroupDatasetTransformation
implements SequencesGroupDatasetTransformation {
    private final Function<SequencesGroup[], SequencesGroupDataset> builder = factory::newSequencesGroupDataset;
    private final SequencesGroupBuilder groupBuilder = factory::newSequencesGroup;
    private final String mergeName;

    public MergeSequencesGroupDatasetTransformation(String mergeName) {
        this(DatatypeFactory.getDefaultDatatypeFactory(), mergeName);
    }

    public MergeSequencesGroupDatasetTransformation(DatatypeFactory factory, String mergeName) {
        this.mergeName = mergeName;
    }

    @Override
    public SequencesGroupDataset transform(SequencesGroupDataset dataset) {
        LinkedList<Sequence> sequences = new LinkedList<Sequence>();
        dataset.getSequencesGroups().forEach(g -> sequences.addAll(g.getSequences().collect(Collectors.toList())));
        return this.builder.apply(new SequencesGroup[]{this.groupBuilder.of(this.mergeName, this.getDatasetPropertiesMap(dataset), sequences)});
    }
}

