/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.plugin.spi;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.sing_group.seda.plugin.spi.TransformationChangeEvent;
import org.sing_group.seda.plugin.spi.TransformationChangeListener;
import org.sing_group.seda.plugin.spi.TransformationChangeType;
import org.sing_group.seda.plugin.spi.TransformationProvider;

public abstract class AbstractTransformationProvider
implements TransformationProvider {
    private final List<TransformationChangeListener> listeners = new CopyOnWriteArrayList<TransformationChangeListener>();

    @Override
    public boolean addTransformationChangeListener(TransformationChangeListener listener) {
        if (this.listeners.contains(listener)) {
            return false;
        }
        return this.listeners.add(listener);
    }

    @Override
    public boolean removeTranformationChangeListener(TransformationChangeListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public boolean containsTransformationChangeListener(TransformationChangeListener listener) {
        return this.listeners.contains(listener);
    }

    protected void fireTransformationsConfigurationModelEvent(TransformationChangeType type, Object newValue) {
        this.fireTransformationsConfigurationModelEvent(type, null, newValue);
    }

    protected void fireTransformationsConfigurationModelEvent(TransformationChangeType type, Object oldValue, Object newValue) {
        this.fireTransformationsConfigurationModelEvent(TransformationChangeEvent.of(this, type, oldValue, newValue));
    }

    protected void fireTransformationsConfigurationModelEvent(TransformationChangeEvent event) {
        this.listeners.forEach(listener -> listener.onTransformationChange(event));
    }
}

