/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.plugin.core.gui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.core.io.JsonObjectWriter;
import org.sing_group.seda.gui.configuration_panel.split.regex.RegexSplitConfigurationPanel;
import org.sing_group.seda.plugin.core.gui.AbstractSedaGuiPlugin;
import org.sing_group.seda.plugin.core.info.plugin.RegexSplitSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.split.regex.RegexSplitConfigurationTransformationProvider;

public class RegexSplitSedaGuiPlugin
extends AbstractSedaGuiPlugin {
    private final RegexSplitConfigurationPanel panel = new RegexSplitConfigurationPanel();

    @Override
    public String getName() {
        return "Regular Expression Split";
    }

    @Override
    public String getGroupName() {
        return RegexSplitSedaPluginInfo.GROUP;
    }

    @Override
    public String getDescription() {
        return "Split each input FASTA file based on regular expression patterns.";
    }

    @Override
    public Component getEditor() {
        return this.panel;
    }

    @Override
    public TransformationProvider getTransformation() {
        return this.panel.getTransformationProvider();
    }

    @Override
    public boolean canSaveTransformation() {
        return true;
    }

    @Override
    public void saveTransformation(File file) throws IOException {
        new JsonObjectWriter<RegexSplitConfigurationTransformationProvider>().write(this.panel.getTransformationProvider(), file);
    }

    @Override
    public void loadTransformation(File file) throws IOException {
        this.panel.setTransformationProvider((RegexSplitConfigurationTransformationProvider)new JsonObjectReader().read(file, RegexSplitConfigurationTransformationProvider.class));
    }
}

