/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.io;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.sing_group.seda.io.IOUtils;
import org.sing_group.seda.io.NumberedLineReader;

public enum LineBreakType {
    WINDOWS("Windows", "\r\n"),
    UNIX("Unix", "\n");

    private String description;
    private String lineBreak;

    private LineBreakType(String description, String lineBreak) {
        this.description = description;
        this.lineBreak = lineBreak;
    }

    public String getLineBreak() {
        return this.lineBreak;
    }

    public boolean isDefault() {
        return this == LineBreakType.defaultType();
    }

    public String toString() {
        return this.description;
    }

    public static LineBreakType defaultType() {
        return UNIX;
    }

    public static LineBreakType forString(String lineBreak) {
        if (lineBreak.equals(WINDOWS.getLineBreak())) {
            return WINDOWS;
        }
        return UNIX;
    }

    public static LineBreakType forFile(Path file) {
        return LineBreakType.forFile(file, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LineBreakType forFile(Path file, Charset charset) {
        try (NumberedLineReader reader = IOUtils.createNumberedLineReader(file, charset);){
            NumberedLineReader.Line nline = reader.readLine();
            if (nline != null) {
                LineBreakType lineBreakType = LineBreakType.forString(nline.getLineEnding());
                return lineBreakType;
            }
            throw new RuntimeException("Error reading file: " + file.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading file: " + file.toString());
        }
    }
}

