/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPInputStream;
import org.mozilla.universalchardet.UniversalDetector;
import org.sing_group.seda.io.NumberedLineReader;

public final class IOUtils {
    private IOUtils() {
    }

    public static boolean isGZipped(InputStream in) {
        if (!in.markSupported()) {
            throw new IllegalArgumentException("in must support mark");
        }
        in.mark(2);
        try {
            int magic = in.read() & 0xFF | in.read() << 8 & 0xFF00;
            in.reset();
            return magic == 35615;
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Path extractIfNeeded(Path file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file, StandardOpenOption.READ));){
            if (IOUtils.isGZipped(in)) {
                String name = file.getFileName().toString();
                Path tempFile = Files.createTempFile("seda_" + name, ".fasta", new FileAttribute[0]);
                try (GZIPInputStream gis = new GZIPInputStream(in);){
                    Files.copy(gis, tempFile, StandardCopyOption.REPLACE_EXISTING);
                    Path path = tempFile;
                    return path;
                }
            }
            Path path = file;
            return path;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error uncompressing file: " + file, e);
        }
    }

    public static InputStream createInputStream(Path file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file, StandardOpenOption.READ));
        return IOUtils.isGZipped(in) ? new GZIPInputStream(in) : in;
    }

    public static Reader createReader(Path file, Charset charset) throws IOException {
        return new InputStreamReader(IOUtils.createInputStream(file), charset == null ? Charset.defaultCharset() : charset);
    }

    public static Charset detectCharset(Path file) throws IOException {
        try (InputStream input = IOUtils.createInputStream(file);){
            String charsetName = UniversalDetector.detectCharset((InputStream)input);
            Charset charset = charsetName == null ? Charset.defaultCharset() : Charset.forName(charsetName);
            return charset;
        }
    }

    public static NumberedLineReader createNumberedLineReader(Path file, Charset charset) throws IOException {
        return new NumberedLineReader(IOUtils.createInputStream(file), charset);
    }

    public static File createSedaUserHomeDirectory(String name) {
        File sedaUserHome = new File(IOUtils.getInitialOutputDirectory(), name);
        sedaUserHome.mkdirs();
        Path path = sedaUserHome.toPath();
        try {
            Files.setAttribute(path, "dos:hidden", true, new LinkOption[0]);
        }
        catch (IOException | UnsupportedOperationException e) {
            System.out.println("Setting 'hidden' attribute is not supported on this platform.");
        }
        return path.toFile();
    }

    private static String getInitialOutputDirectory() {
        return System.getProperty("seda.output.directory", System.getProperty("user.home"));
    }
}

