/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.filtering.base;

import java.awt.Component;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXTextField;
import org.sing_group.gc4s.event.DocumentAdapter;
import org.sing_group.gc4s.input.DoubleRange;
import org.sing_group.gc4s.input.DoubleRangeSpinnerInputPanel;
import org.sing_group.gc4s.ui.icons.Icons;
import org.sing_group.seda.core.operations.BasePresence;
import org.sing_group.seda.plugin.core.info.plugin.FilterByBasePresenceSedaPluginInfo;

public class BasePresenceConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_BASE_PRESENCE = "seda.base.presence";
    private JXTextField basesTextField;
    private DoubleRangeSpinnerInputPanel rangePanel;
    private BasePresence oldValue;
    private BasePresence initialValue;

    public BasePresenceConfigurationPanel() {
        this((BasePresence)null);
    }

    public BasePresenceConfigurationPanel(BasePresence basePresence) {
        this.initialValue = basePresence;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel("Base(s): "));
        this.add(this.getBasesTextField());
        this.add(Box.createHorizontalStrut(5));
        this.add(this.getBasesHelp());
        this.add(Box.createHorizontalStrut(10));
        this.add(this.getBasesPercentagesComponent());
        this.add(Box.createHorizontalStrut(5));
        this.add(this.getPercentagesHelp());
    }

    private JLabel getBasesHelp() {
        JLabel helpLabel = new JLabel(Icons.ICON_INFO_2_16);
        helpLabel.setToolTipText(FilterByBasePresenceSedaPluginInfo.PARAM_BASE_FILTER_HELP_GUI);
        return helpLabel;
    }

    private JLabel getPercentagesHelp() {
        JLabel helpLabel = new JLabel(Icons.ICON_INFO_2_16);
        helpLabel.setToolTipText("The minimum and maximum percentages allowed for the specified base(s).");
        return helpLabel;
    }

    private Component getBasesTextField() {
        this.basesTextField = new JXTextField("ACTG");
        this.basesTextField.setColumns(6);
        if (this.initialValue != null) {
            this.basesTextField.setText(this.initialValue.getBases().stream().map(Object::toString).collect(Collectors.joining()));
        }
        this.basesTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void removeUpdate(DocumentEvent e) {
                BasePresenceConfigurationPanel.this.configurationChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                BasePresenceConfigurationPanel.this.configurationChanged();
            }
        });
        return this.basesTextField;
    }

    private Component getBasesPercentagesComponent() {
        this.rangePanel = new DoubleRangeSpinnerInputPanel(0.0, 1.0, 0.0, 1.0, 0.1);
        this.rangePanel.setStartLabel("Min. % ");
        this.rangePanel.setEndLabel("Max. % ");
        if (this.initialValue != null) {
            this.rangePanel.setSelectedRange(new DoubleRange(this.initialValue.getMinimumPresence(), this.initialValue.getMaximumPresence()));
        }
        this.rangePanel.addPropertyChangeListener("value", e -> this.configurationChanged());
        return this.rangePanel;
    }

    private void configurationChanged() {
        BasePresence newValue = null;
        try {
            newValue = this.getBasePresence();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.firePropertyChange(PROPERTY_BASE_PRESENCE, this.oldValue, newValue);
        this.oldValue = newValue;
    }

    public BasePresence getBasePresence() {
        DoubleRange range = this.rangePanel.getRange();
        return new BasePresence(range.getMin(), range.getMax(), this.basesTextField.getText().toCharArray());
    }

    public boolean isValidValue() {
        return this.basesTextField.getText() != null && !this.basesTextField.getText().isEmpty() && this.rangePanel.isValidRange();
    }
}

