/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.filtering;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanel;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanelBuilder;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.gc4s.ui.icons.Icons;
import org.sing_group.gc4s.utilities.builder.JButtonBuilder;
import org.sing_group.seda.gui.CommonFileChooser;
import org.sing_group.seda.gui.GuiUtils;
import org.sing_group.seda.gui.configuration_panel.filtering.header.HeaderFilteringConfigurationPanel;
import org.sing_group.seda.plugin.core.info.plugin.FilteringSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationChangeListener;
import org.sing_group.seda.transformation.provider.filtering.FilteringConfigurationEventType;
import org.sing_group.seda.transformation.provider.filtering.FilteringConfigurationTransformationProvider;

public class FilteringConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String HELP_STARTING_CODONS = FilteringSedaPluginInfo.PARAM_STARTING_CODON_HELP_GUI;
    private static final String HELP_REMOVE_NON_MULTIPLE_3 = FilteringSedaPluginInfo.PARAM_NON_MULTIPLE_3_HELP_GUI;
    private static final String HELP_REMOVE_SEQUENCES_IN_FRAME_STOP_CODONS = FilteringSedaPluginInfo.PARAM_IN_FRAME_STOP_CODONS_HELP_GUI;
    private static final String HELP_MINIMUM_SEQUENCE_LENGTH = FilteringSedaPluginInfo.PARAM_MINIMUM_SEQUENCE_LENGTH_HELP_GUI;
    private static final String HELP_MAXIMUM_SEQUENCE_LENGTH = FilteringSedaPluginInfo.PARAM_MAXIMUM_SEQUENCE_LENGTH_HELP_GUI;
    private static final String HELP_MINIMUM_NUMBER_OF_SEQUENCES = FilteringSedaPluginInfo.PARAM_MINIMUM_SEQUENCES_HELP_GUI;
    private static final String HELP_MAXIMUM_NUMBER_OF_SEQUENCES = FilteringSedaPluginInfo.PARAM_MAXIMUM_SEQUENCES_HELP_GUI;
    private static final String HELP_REMOVE_SIZE_DIFFERENCE = FilteringSedaPluginInfo.PARAM_REMOVE_SIZE_DIFFERENCE_HELP_GUI;
    private static final String HELP_MAX_SIZE_DIFFERENCE = FilteringSedaPluginInfo.PARAM_MAX_SIZE_DIFFERENCE_HELP_GUI;
    private static final String HELP_REFERENCE_SEQUENCE_INDEX = FilteringSedaPluginInfo.PARAM_SEQUENCE_INDEX_HELP_GUI;
    private static final String HELP_REFERENCE_SEQUENCE_FILE = FilteringSedaPluginInfo.PARAM_SEQUENCE_FILE_HELP_GUI;
    private static final String HELP_HEADER_COUNT_FILTERING = "<html>Filters sequences or files so that only those meeting the specified criteria regarding counts on their headers are kept.<br/>Click the <i>Use this filter</i> button in order to show the corresponding configuration panel.<br/>For instance, if you want to kep only those sequences with unique sequence names (or identifiers), you should use the following configuration:<ul><li>Mode: keep.</li> <li>Level: sequence.</li> <li>Range: (1, 1). <li>Filter type: Sequence name.</li></li></ul></html>";
    private FilteringConfigurationTransformationProvider model;
    private TransformationChangeListener transformationChangeListener;
    private JXTaskPane translationConfigurationTaskPane;
    private JCheckBox chkRemoveNonMultipleOfThree;
    private JCheckBox chkRemoveIfInFrameStopCodon;
    private JCheckBox chkRemoveBySizeDifference;
    private JSpinner spnSizeDifference;
    private JSpinner spnReferenceIndex;
    private JSpinner spnMinNumberOfSequences;
    private JSpinner spnMaxNumberOfSequences;
    private JSpinner spnMinSequenceLength;
    private JSpinner spnMaxSequenceLength;
    private JFileChooserPanel referenceIndexFile;
    private JButton clearReferenceIndexFileButton;
    private Map<String, JCheckBox> codonToChk = new HashMap<String, JCheckBox>();
    private JButton btnUnselectCodons;
    private JButton btnSelectCodons;
    private HeaderFilteringConfigurationPanel headerFilteringParametersPanel;

    public FilteringConfigurationPanel() {
        this.add((Component)new CenteredJPanel(this.getParametersPanel()));
    }

    private Component getParametersPanel() {
        this.model = new FilteringConfigurationTransformationProvider();
        InputParametersPanel parametersPanel = new InputParametersPanel(InputParametersPanel.DescriptionAlignment.RIGHT, this.getParameters());
        this.toggleSizeDifferenceControls();
        this.bindGuiControls();
        this.referenceIndexFile.addFileChooserListener(f -> this.referenceIndexFileChanged());
        this.transformationChangeListener = event -> {
            switch ((FilteringConfigurationEventType)event.getType()) {
                case STARTING_CODON_ADDED: 
                case STARTING_CODON_REMOVED: {
                    this.updateStartingCodons((String)event.getNewValue());
                    break;
                }
                case REMOVE_NON_MULTIPLE_OF_THREE_CHANGED: {
                    this.updateRemoveNonMultipleOfThree();
                    break;
                }
                case REMOVE_IF_IN_FRAME_STOP_CODON_CHANGED: {
                    this.updateRemoveIfInFrameStopCodon();
                    break;
                }
                case REMOVE_BY_SIZE_DIFFERENCE_CHANGED: {
                    this.updateRemoveBySizeDifference();
                    break;
                }
                case SIZE_DIFFERENCE_CHANGED: {
                    this.updateSizeDifference();
                    break;
                }
                case REFERENCE_INDEX_CHANGED: {
                    this.updateReferenceIndex();
                    break;
                }
                case REFERENCE_FILE_CHANGED: {
                    this.updateReferenceFile();
                    break;
                }
                case MIN_NUM_OF_SEQUENCES_CHANGED: {
                    this.updateMinNumberOfSequences();
                    break;
                }
                case MAX_NUM_OF_SEQUENCES_CHANGED: {
                    this.updateMaxNumberOfSequences();
                    break;
                }
                case MIN_SEQUENCE_LENGTH_CHANGED: {
                    this.updateMinSequenceLength();
                    break;
                }
                case MAX_SEQUENCE_LENGTH_CHANGED: {
                    this.updateMaxSequenceLength();
                    break;
                }
                case HEADER_FILTERING_CONFIGURATION_CHANGED: {
                    this.updateHeaderFilteringConfiguration();
                }
            }
        };
        this.model.addTransformationChangeListener(this.transformationChangeListener);
        return parametersPanel;
    }

    private void bindGuiControls() {
        GuiUtils.bindCheckBox(this.chkRemoveNonMultipleOfThree, this.model::setRemoveNonMultipleOfThree);
        GuiUtils.bindCheckBox(this.chkRemoveIfInFrameStopCodon, this.model::setRemoveIfInFrameStopCodon);
        GuiUtils.bindCheckBox(this.chkRemoveBySizeDifference, this.model::setRemoveBySizeDifference);
        GuiUtils.bindSpinner(this.spnSizeDifference, this.model::setSizeDifference);
        GuiUtils.bindSpinner(this.spnReferenceIndex, this.model::setReferenceIndex);
        GuiUtils.bindSpinner(this.spnMinNumberOfSequences, this.model::setMinNumOfSequences);
        GuiUtils.bindSpinner(this.spnMaxNumberOfSequences, this.model::setMaxNumOfSequences);
        GuiUtils.bindSpinner(this.spnMinSequenceLength, this.model::setMinSequenceLength);
        GuiUtils.bindSpinner(this.spnMaxSequenceLength, this.model::setMaxSequenceLength);
    }

    private void referenceIndexFileChanged() {
        if (this.referenceIndexFile.getSelectedFile() == null) {
            this.model.clearReferenceFile();
        } else {
            this.model.setReferenceFile(this.referenceIndexFile.getSelectedFile());
            boolean validReferenceFile = this.model.isValidReferenceFile();
            if (!validReferenceFile && this.referenceIndexFile.getSelectedFile() != null) {
                JOptionPane.showMessageDialog(this, "Warning: the selected reference file is not valid. Please, select a different one.", "Invalid reference sequence file", 2);
                SwingUtilities.invokeLater(() -> this.clearReferenceIndexFile());
            }
        }
    }

    private InputParameter[] getParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getValidStartingCodonsParameter());
        parameters.add(this.getRemoveNonMultipleOfThreeSequencesParameter());
        parameters.add(this.getRemoveSequencesWithInFrameStopCodonsParameter());
        parameters.add(this.getMinimumSequenceLengthParameter());
        parameters.add(this.getMaximumSequenceLengthParameter());
        parameters.add(this.getMinimumNumberOfSequencesParameter());
        parameters.add(this.getMaximumNumberOfSequencesParameter());
        parameters.add(this.getRemoveBySizeDifferenceParameter());
        parameters.add(this.getMaximumSizeDiferenceParameter());
        parameters.add(this.getReferenceSequenceIndexParameter());
        parameters.add(this.getReferenceSequenceFileParameter());
        parameters.add(this.getHeaderFilteringConfigurationPanel());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getValidStartingCodonsParameter() {
        JXTaskPaneContainer customOptionsTaskPaneContainer = new JXTaskPaneContainer();
        customOptionsTaskPaneContainer.setOpaque(false);
        customOptionsTaskPaneContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.translationConfigurationTaskPane = new JXTaskPane();
        this.translationConfigurationTaskPane.setTitle("Codons");
        this.translationConfigurationTaskPane.add((Component)this.getValidStartingCodonsPanel());
        this.translationConfigurationTaskPane.setCollapsed(true);
        customOptionsTaskPaneContainer.add((Component)this.translationConfigurationTaskPane);
        return new InputParameter("Valid starting codons:", (JComponent)customOptionsTaskPaneContainer, HELP_STARTING_CODONS);
    }

    private JPanel getValidStartingCodonsPanel() {
        char[] nucleotides;
        JPanel validStartingCodons = new JPanel(new GridLayout(16, 4));
        for (char first : nucleotides = new char[]{'A', 'C', 'T', 'G'}) {
            for (char second : nucleotides) {
                for (char third : nucleotides) {
                    String codon = new String(new char[]{first, second, third});
                    JCheckBox chkCodon = new JCheckBox(codon, this.model.hasStartingCodon(codon));
                    this.codonToChk.put(codon, chkCodon);
                    validStartingCodons.add(chkCodon);
                }
            }
        }
        this.btnSelectCodons = new JButton("Select all codons");
        this.btnUnselectCodons = new JButton("Unselect all codons");
        JPanel buttons = new JPanel(new FlowLayout());
        buttons.add(this.btnSelectCodons);
        buttons.add(this.btnUnselectCodons);
        JPanel validStartingCodonsPanel = new JPanel(new BorderLayout());
        validStartingCodonsPanel.add((Component)validStartingCodons, "Center");
        validStartingCodonsPanel.add((Component)buttons, "North");
        this.codonToChk.entrySet().forEach(entry -> {
            String codon = (String)entry.getKey();
            JCheckBox chkCodon = (JCheckBox)entry.getValue();
            chkCodon.addItemListener(event -> {
                if (chkCodon.isSelected()) {
                    this.model.addStartingCodon(codon);
                } else {
                    this.model.removeStartingCodon(codon);
                }
            });
        });
        this.btnSelectCodons.addActionListener(event -> this.codonToChk.keySet().forEach(this.model::addStartingCodon));
        this.btnUnselectCodons.addActionListener(event -> this.codonToChk.keySet().forEach(this.model::removeStartingCodon));
        return validStartingCodonsPanel;
    }

    private InputParameter getRemoveNonMultipleOfThreeSequencesParameter() {
        this.chkRemoveNonMultipleOfThree = new JCheckBox();
        this.chkRemoveNonMultipleOfThree.setSelected(this.model.isRemoveNonMultipleOfThree());
        return new InputParameter("Remove sequences with a non-multiple of three length:", (JComponent)this.chkRemoveNonMultipleOfThree, HELP_REMOVE_NON_MULTIPLE_3);
    }

    private InputParameter getRemoveSequencesWithInFrameStopCodonsParameter() {
        this.chkRemoveIfInFrameStopCodon = new JCheckBox();
        this.chkRemoveIfInFrameStopCodon.setSelected(this.model.isRemoveIfInFrameStopCodon());
        return new InputParameter("Remove sequences with in-frame stop codons:", (JComponent)this.chkRemoveIfInFrameStopCodon, HELP_REMOVE_SEQUENCES_IN_FRAME_STOP_CODONS);
    }

    private InputParameter getMinimumSequenceLengthParameter() {
        this.spnMinSequenceLength = new JSpinner(new SpinnerNumberModel(this.model.getMinSequenceLength(), 0, Integer.MAX_VALUE, 1));
        return new InputParameter("Minimum sequence length:", (JComponent)this.spnMinSequenceLength, HELP_MINIMUM_SEQUENCE_LENGTH);
    }

    private InputParameter getMaximumSequenceLengthParameter() {
        this.spnMaxSequenceLength = new JSpinner(new SpinnerNumberModel(this.model.getMaxSequenceLength(), 0, Integer.MAX_VALUE, 1));
        return new InputParameter("Maximum sequence length:", (JComponent)this.spnMaxSequenceLength, HELP_MAXIMUM_SEQUENCE_LENGTH);
    }

    private InputParameter getMinimumNumberOfSequencesParameter() {
        this.spnMinNumberOfSequences = new JSpinner(new SpinnerNumberModel(this.model.getMinNumOfSequences(), 0, Integer.MAX_VALUE, 1));
        return new InputParameter("Minimum number of sequences:", (JComponent)this.spnMinNumberOfSequences, HELP_MINIMUM_NUMBER_OF_SEQUENCES);
    }

    private InputParameter getMaximumNumberOfSequencesParameter() {
        this.spnMaxNumberOfSequences = new JSpinner(new SpinnerNumberModel(this.model.getMaxNumOfSequences(), 0, Integer.MAX_VALUE, 1));
        return new InputParameter("Maximum number of sequences:", (JComponent)this.spnMaxNumberOfSequences, HELP_MAXIMUM_NUMBER_OF_SEQUENCES);
    }

    private InputParameter getRemoveBySizeDifferenceParameter() {
        this.chkRemoveBySizeDifference = new JCheckBox();
        this.chkRemoveBySizeDifference.setSelected(this.model.isRemoveBySizeDifference());
        return new InputParameter("Remove by sequence length difference:", (JComponent)this.chkRemoveBySizeDifference, HELP_REMOVE_SIZE_DIFFERENCE);
    }

    private InputParameter getMaximumSizeDiferenceParameter() {
        this.spnSizeDifference = new JSpinner(new SpinnerNumberModel(this.model.getSizeDifference(), 0, Integer.MAX_VALUE, 1));
        return new InputParameter("Maximum length difference (%):", (JComponent)this.spnSizeDifference, HELP_MAX_SIZE_DIFFERENCE);
    }

    private InputParameter getReferenceSequenceIndexParameter() {
        this.spnReferenceIndex = new JSpinner(new SpinnerNumberModel(this.model.getReferenceIndex(), 1, Integer.MAX_VALUE, 1));
        return new InputParameter("Reference sequence index:", (JComponent)this.spnReferenceIndex, HELP_REFERENCE_SEQUENCE_INDEX);
    }

    private InputParameter getReferenceSequenceFileParameter() {
        this.referenceIndexFile = JFileChooserPanelBuilder.createOpenJFileChooserPanel().withFileChooser(CommonFileChooser.getInstance().getFilechooser()).withLabel("").build();
        this.referenceIndexFile.setClearSelectedFileActionEnabled(false);
        this.clearReferenceIndexFileButton = JButtonBuilder.newJButtonBuilder().withIcon((Icon)Icons.ICON_TRASH_16).withTooltip("Clears the selected reference sequence file.").thatDoes((Action)new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FilteringConfigurationPanel.this.clearReferenceIndexFile();
            }
        }).build();
        JPanel referenceIndexFilePanel = new JPanel();
        referenceIndexFilePanel.setLayout(new BoxLayout(referenceIndexFilePanel, 0));
        referenceIndexFilePanel.add((Component)this.referenceIndexFile);
        referenceIndexFilePanel.add(Box.createHorizontalStrut(5));
        referenceIndexFilePanel.add(this.clearReferenceIndexFileButton);
        return new InputParameter("Reference sequence file:", (JComponent)referenceIndexFilePanel, HELP_REFERENCE_SEQUENCE_FILE);
    }

    private void clearReferenceIndexFile() {
        this.referenceIndexFile.clearSelectedFile();
    }

    private InputParameter getHeaderFilteringConfigurationPanel() {
        this.headerFilteringParametersPanel = new HeaderFilteringConfigurationPanel();
        this.headerFilteringParametersPanel.addPropertyChangeListener("filtering.configuration", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FilteringConfigurationPanel.this.model.setHeaderFilteringConfiguration(FilteringConfigurationPanel.this.headerFilteringParametersPanel.getHeaderFilteringConfiguration());
            }
        });
        return new InputParameter("Header count filtering:", (JComponent)this.headerFilteringParametersPanel, HELP_HEADER_COUNT_FILTERING);
    }

    public FilteringConfigurationTransformationProvider getTransformationProvider() {
        return this.model;
    }

    public void setTransformationProvider(FilteringConfigurationTransformationProvider model) {
        this.model.removeTranformationChangeListener(this.transformationChangeListener);
        this.model = model;
        this.codonToChk.keySet().forEach(this::updateStartingCodons);
        this.updateRemoveNonMultipleOfThree();
        this.updateRemoveIfInFrameStopCodon();
        this.updateRemoveBySizeDifference();
        this.updateSizeDifference();
        this.updateReferenceIndex();
        this.updateReferenceFile();
        this.updateMinNumberOfSequences();
        this.updateMaxNumberOfSequences();
        this.updateMinSequenceLength();
        this.updateMaxSequenceLength();
        this.updateHeaderFilteringConfiguration();
        SwingUtilities.invokeLater(() -> this.translationConfigurationTaskPane.setCollapsed(!model.getStartingCodons().findFirst().isPresent()));
        this.bindGuiControls();
        this.model.addTransformationChangeListener(this.transformationChangeListener);
    }

    public void updateStartingCodons(String codon) {
        this.codonToChk.get(codon).setSelected(this.model.hasStartingCodon(codon));
    }

    public void updateRemoveNonMultipleOfThree() {
        this.chkRemoveNonMultipleOfThree.setSelected(this.model.isRemoveNonMultipleOfThree());
    }

    public void updateRemoveIfInFrameStopCodon() {
        this.chkRemoveIfInFrameStopCodon.setSelected(this.model.isRemoveIfInFrameStopCodon());
    }

    public void updateRemoveBySizeDifference() {
        this.chkRemoveBySizeDifference.setSelected(this.model.isRemoveBySizeDifference());
        this.toggleSizeDifferenceControls();
    }

    public void updateSizeDifference() {
        this.spnSizeDifference.setValue(this.model.getSizeDifference());
    }

    public void updateReferenceIndex() {
        this.spnReferenceIndex.setValue(this.model.getReferenceIndex());
    }

    public void updateReferenceFile() {
        if (this.model.getReferenceFile().isPresent()) {
            this.referenceIndexFile.setSelectedFile(this.model.getReferenceFile().get());
        } else {
            this.clearReferenceIndexFile();
        }
    }

    public void updateHeaderFilteringConfiguration() {
        this.headerFilteringParametersPanel.setHeaderFilteringConfiguration(this.model.getHeaderFilteringConfiguration());
    }

    public void updateMinNumberOfSequences() {
        this.spnMinNumberOfSequences.setValue(this.model.getMinNumOfSequences());
    }

    public void updateMaxNumberOfSequences() {
        this.spnMaxNumberOfSequences.setValue(this.model.getMaxNumOfSequences());
    }

    public void updateMinSequenceLength() {
        this.spnMinSequenceLength.setValue(this.model.getMinSequenceLength());
        this.checkSequenceLengthConfiguration();
    }

    public void updateMaxSequenceLength() {
        this.spnMaxSequenceLength.setValue(this.model.getMaxSequenceLength());
        this.checkSequenceLengthConfiguration();
    }

    private void checkSequenceLengthConfiguration() {
        boolean valid = this.model.isValidSequenceLengthConfiguration();
        Color background = valid ? Color.WHITE : GuiUtils.COLOR_ERROR;
        this.spnMaxSequenceLength.getEditor().getComponent(0).setBackground(background);
        this.spnMinSequenceLength.getEditor().getComponent(0).setBackground(background);
    }

    private void toggleSizeDifferenceControls() {
        boolean enabled = this.model.isRemoveBySizeDifference();
        this.spnSizeDifference.setEnabled(enabled);
        this.spnReferenceIndex.setEnabled(enabled);
        this.referenceIndexFile.getBrowseAction().setEnabled(enabled);
        this.clearReferenceIndexFileButton.setEnabled(enabled);
    }
}

