/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.RadioButtonsPanel;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.core.rename.AddStringHeaderRenamer;
import org.sing_group.seda.core.rename.HeaderRenamer;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.gui.configuration_panel.rename.AddStringHeaderRenamePanel;
import org.sing_group.seda.plugin.core.info.plugin.ReverseComplementSedaPluginInfo;
import org.sing_group.seda.transformation.provider.reverse_complement.ReverseComplementTransformationProvider;

public class ReverseComplementTransformationConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ReverseComplementTransformationProvider transformationProvider;
    private JCheckBox reverseCb;
    private JCheckBox complementCb;
    private JCheckBox renameSequenceHeadersCb;
    private RadioButtonsPanel<HeaderTarget> headerTargetRbtnPanel;
    private AddStringHeaderRenamePanel addStringHeaderRenamePanel;

    public ReverseComplementTransformationConfigurationPanel() {
        this.init();
        this.initTransformationProvider();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        return new CenteredJPanel((Component)new InputParametersPanel(this.getParameters()));
    }

    private InputParameter[] getParameters() {
        InputParameter[] parameters = new InputParameter[]{this.getReverseParameter(), this.getComplementParameter(), this.getRenameSequenceHeadersParameter(), this.getHeaderRenamerParameter()};
        return parameters;
    }

    private InputParameter getReverseParameter() {
        this.reverseCb = new JCheckBox("Reverse", true);
        this.reverseCb.addItemListener(e -> this.reverseChanged());
        return new InputParameter("", (JComponent)this.reverseCb, ReverseComplementSedaPluginInfo.PARAM_REVERSE_HELP_GUI);
    }

    private void reverseChanged() {
        this.transformationProvider.setReverseSequences(this.reverseCb.isSelected());
    }

    private InputParameter getComplementParameter() {
        this.complementCb = new JCheckBox("Complement", true);
        this.complementCb.addItemListener(e -> this.complementChanged());
        return new InputParameter("", (JComponent)this.complementCb, ReverseComplementSedaPluginInfo.PARAM_COMPLEMENT_HELP_GUI);
    }

    private void complementChanged() {
        this.transformationProvider.setComplementSequences(this.complementCb.isSelected());
    }

    private InputParameter getRenameSequenceHeadersParameter() {
        this.renameSequenceHeadersCb = new JCheckBox("Rename sequence headers", false);
        this.renameSequenceHeadersCb.addItemListener(e -> this.renameSequenceHeadersConfigurationChanged());
        return new InputParameter("", (JComponent)this.renameSequenceHeadersCb, ReverseComplementSedaPluginInfo.PARAM_RENAME_SEQUENCE_HEADERS_HELP_GUI);
    }

    private void renameSequenceHeadersConfigurationChanged() {
        this.renameConfigurationChanged();
    }

    private InputParameter getHeaderRenamerParameter() {
        this.headerTargetRbtnPanel = new RadioButtonsPanel((Object[])HeaderTarget.values(), 1, 2);
        this.headerTargetRbtnPanel.addItemListener(this::headerTargetValueChanged);
        this.addStringHeaderRenamePanel = new AddStringHeaderRenamePanel(false, Arrays.asList(new InputParameter("Target", this.headerTargetRbtnPanel, "The header target.")));
        this.addStringHeaderRenamePanel.addRenamePanelEventListener(source -> this.renameConfigurationChanged());
        this.addStringHeaderRenamePanel.setBorder(BorderFactory.createTitledBorder("Renaming configuration"));
        return new InputParameter("", (JComponent)this.addStringHeaderRenamePanel, "The sequence headers renaming configuration.");
    }

    private void headerTargetValueChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.renameConfigurationChanged();
        }
    }

    private void renameConfigurationChanged() {
        if (this.renameSequenceHeadersCb.isSelected() && this.addStringHeaderRenamePanel.isValidConfiguration()) {
            this.transformationProvider.setHeaderRenamer((AddStringHeaderRenamer)this.getHeaderRenamer());
        } else {
            this.transformationProvider.clearHeaderRenamer();
        }
    }

    public HeaderRenamer getHeaderRenamer() {
        return this.addStringHeaderRenamePanel.getHeaderRenamer(this.getHeaderTarget());
    }

    private HeaderTarget getHeaderTarget() {
        return (HeaderTarget)((Object)this.headerTargetRbtnPanel.getSelectedItem().get());
    }

    public ReverseComplementTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    private void initTransformationProvider() {
        this.transformationProvider = new ReverseComplementTransformationProvider(this.reverseCb.isSelected(), this.complementCb.isSelected());
    }

    public void setTransformationProvider(ReverseComplementTransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
        this.reverseCb.setSelected(this.transformationProvider.isReverseSequences());
        this.complementCb.setSelected(this.transformationProvider.isComplementSequences());
        AddStringHeaderRenamer renamer = this.transformationProvider.getHeaderRenamer();
        if (renamer != null) {
            this.addStringHeaderRenamePanel.setHeaderRenamer(renamer);
            this.headerTargetRbtnPanel.setSelectedItem((Object)renamer.getHeaderTarget());
            this.renameSequenceHeadersCb.setSelected(true);
        }
    }
}

