/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.text.JIntegerTextField;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.gui.GuiUtils;
import org.sing_group.seda.plugin.core.info.plugin.GrowSequencesSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationChangeEvent;
import org.sing_group.seda.transformation.provider.grow.GrowSequencesConfigurationChangeType;
import org.sing_group.seda.transformation.provider.grow.GrowSequencesTransformationProvider;

public class GrowSequencesConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private GrowSequencesTransformationProvider transformationProvider = new GrowSequencesTransformationProvider();
    private JIntegerTextField minimumOverlappingTf;

    public GrowSequencesConfigurationPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
        this.bindGuiControls();
        this.transformationProvider.addTransformationChangeListener(this::modelChanged);
    }

    private JPanel getMainPanel() {
        return new CenteredJPanel((Component)new InputParametersPanel(this.getParameters()));
    }

    private InputParameter[] getParameters() {
        InputParameter[] parameters = new InputParameter[]{this.getNumberOfSequencesParameter()};
        return parameters;
    }

    private InputParameter getNumberOfSequencesParameter() {
        this.minimumOverlappingTf = new JIntegerTextField(Integer.valueOf(this.transformationProvider.getMinimumOverlapping()));
        this.minimumOverlappingTf.setColumns(10);
        return new InputParameter("Minimum overlapping: ", (JComponent)this.minimumOverlappingTf, GrowSequencesSedaPluginInfo.PARAM_MINIMUM_OVERLAPPING_HELP_GUI);
    }

    private void bindGuiControls() {
        GuiUtils.bindIntegerTextField(this.minimumOverlappingTf, this.transformationProvider::setMinimumOverlapping);
    }

    private void modelChanged(TransformationChangeEvent event) {
        SwingUtilities.invokeLater(() -> {
            switch ((GrowSequencesConfigurationChangeType)event.getType()) {
                case MINIMUM_OVERLAPPING_CHANGED: {
                    this.updateMinimumOverlapping();
                }
            }
        });
    }

    private void updateMinimumOverlapping() {
        this.minimumOverlappingTf.setValue((Object)this.transformationProvider.getMinimumOverlapping());
    }

    public GrowSequencesTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(GrowSequencesTransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
        this.updateMinimumOverlapping();
        this.bindGuiControls();
        this.transformationProvider.addTransformationChangeListener(this::modelChanged);
    }
}

