/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.datatype.statistics;

import java.nio.file.Path;
import java.util.IntSummaryStatistics;
import java.util.stream.Collectors;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;

public class SequencesGroupStatistics {
    private Path path;
    private SequencesGroup sequences;
    private String name;
    private int sequenceCount;
    private IntSummaryStatistics lengthSummary;

    public SequencesGroupStatistics(Path path, SequencesGroup sequences) {
        this.path = path;
        this.sequences = sequences;
        this.name = sequences.getName();
        this.sequenceCount = sequences.getSequenceCount();
        this.lengthSummary = sequences.getSequences().collect(Collectors.summarizingInt(Sequence::getLength));
    }

    public String getName() {
        return this.name;
    }

    public int getSequenceCount() {
        return this.sequenceCount;
    }

    public int getMaxSequenceLength() {
        return this.lengthSummary.getMax();
    }

    public int getMinSequenceLength() {
        return this.lengthSummary.getMin();
    }

    public SequencesGroup getSequences() {
        return this.sequences;
    }

    public long getFileSize() {
        return this.path.toFile().length();
    }
}

