/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.datatype;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.sing_group.seda.datatype.Sequence;

public class InMemorySequence
implements Sequence,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String chain;
    private final Map<String, Object> properties;

    public InMemorySequence(String name, String description, String chain, Map<String, Object> properties) {
        this.name = Objects.requireNonNull(name, "name can't be null");
        this.description = description == null ? "" : description;
        this.chain = Objects.requireNonNull(chain, "chain can't be null");
        this.properties = Collections.unmodifiableMap(new HashMap<String, Object>(Objects.requireNonNull(properties, "properties can't be null")));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getChain() {
        return this.chain;
    }

    @Override
    public String getHeader() {
        StringBuilder header = new StringBuilder(">");
        header.append(this.name);
        if (this.description != null && !this.description.isEmpty()) {
            header.append(" ").append(this.description);
        }
        return header.toString();
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public <T> Optional<T> getProperty(String key) {
        return Optional.ofNullable(this.getProperties().get(key));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.chain == null ? 0 : this.chain.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InMemorySequence other = (InMemorySequence)obj;
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        if (this.chain == null ? other.chain != null : !this.chain.equals(other.chain)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return this.getHeader() + "\n" + this.getName() + "\n" + this.getDescription() + "\n" + this.getChain();
    }
}

