/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.rename;

import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.core.rename.HeaderRenamer;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequenceBuilder;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupBuilder;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;

@XmlRootElement
public abstract class AbstractHeaderRenamer
implements HeaderRenamer {
    @XmlElement
    private HeaderTarget target;

    public AbstractHeaderRenamer(HeaderTarget target) {
        this.target = target;
    }

    protected SequencesGroup buildSequencesGroup(String name, Map<String, Object> properties, List<Sequence> renamedSequences, DatatypeFactory factory) {
        return this.getGroupBuilder(factory).of(name, properties, renamedSequences);
    }

    protected Sequence renameSequence(Sequence sequence, String renamedPart, DatatypeFactory factory) {
        String newHeader;
        switch (this.target) {
            case ALL: {
                newHeader = renamedPart;
                break;
            }
            case DESCRIPTION: {
                newHeader = sequence.getName() + " " + renamedPart;
                break;
            }
            case NAME: {
                newHeader = renamedPart + " " + sequence.getDescription();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown header target");
            }
        }
        int firstBlankSpace = newHeader.indexOf(" ");
        if (firstBlankSpace == -1) {
            return this.getSequenceBuilder(factory).of(newHeader, "", sequence.getChain(), sequence.getProperties());
        }
        String newName = newHeader.substring(0, firstBlankSpace);
        String newDescription = newHeader.substring(firstBlankSpace + 1);
        return this.getSequenceBuilder(factory).of(newName, newDescription, sequence.getChain(), sequence.getProperties());
    }

    protected String getRenamePart(Sequence sequence) {
        switch (this.target) {
            case ALL: {
                return sequence.getDescription().isEmpty() ? sequence.getName() : sequence.getName() + " " + sequence.getDescription();
            }
            case DESCRIPTION: {
                return sequence.getDescription();
            }
            case NAME: {
                return sequence.getName();
            }
        }
        throw new IllegalStateException("Unknown header target");
    }

    protected SequencesGroupBuilder getGroupBuilder(DatatypeFactory factory) {
        return factory::newSequencesGroup;
    }

    protected SequenceBuilder getSequenceBuilder(DatatypeFactory factory) {
        return factory::newSequence;
    }

    @Override
    public HeaderTarget getHeaderTarget() {
        return this.target;
    }

    @Override
    public Validation validate() {
        if (this.target == null) {
            return new DefaultValidation("The header target can't be null.");
        }
        return new DefaultValidation(new String[0]);
    }
}

