/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.ncbi;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Optional;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.sing_group.seda.core.ncbi.NcbiTaxonomyFields;
import org.sing_group.seda.core.ncbi.NcbiTaxonomyInfo;

public class NcbiTaxonomyResolver {
    private int timeoutMillis;

    public NcbiTaxonomyResolver() {
        this(10000);
    }

    public NcbiTaxonomyResolver(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public Optional<NcbiTaxonomyInfo> resolve(URL url) {
        try {
            Document doc = Jsoup.parse((URL)url, (int)this.timeoutMillis);
            Optional<Element> lineageDl = this.findLineageDl(doc);
            if (lineageDl.isPresent()) {
                return this.extractNcbiTaxonomyInfo(lineageDl.get());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Optional.empty();
    }

    private Optional<Element> findLineageDl(Document doc) {
        Elements dlElements = doc.getElementsByTag("dl");
        for (Element dlElement : dlElements) {
            Elements dtElements = dlElement.getElementsByTag("dt");
            for (Element dtElement : dtElements) {
                if (!dtElement.text().contains("Lineage")) continue;
                return Optional.of(dlElement);
            }
        }
        return Optional.empty();
    }

    private Optional<NcbiTaxonomyInfo> extractNcbiTaxonomyInfo(Element lineageDl) {
        HashMap<NcbiTaxonomyFields, String> values = new HashMap<NcbiTaxonomyFields, String>();
        if (lineageDl.getElementsByTag("dd").size() > 0) {
            Element lineageDd = (Element)lineageDl.getElementsByTag("dd").get(0);
            block0: for (NcbiTaxonomyFields field : NcbiTaxonomyFields.values()) {
                Elements fieldElements = lineageDd.getElementsByAttributeValue("title", field.nodeTitle());
                for (Element element : fieldElements) {
                    if (!element.attr("title").equals(field.nodeTitle())) continue;
                    values.put(field, element.text());
                    continue block0;
                }
            }
        }
        return Optional.of(new NcbiTaxonomyInfo(values));
    }
}

