/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.filtering;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.sing_group.seda.core.filtering.HeaderMatcher;
import org.sing_group.seda.core.filtering.RegexConfiguration;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.datatype.Sequence;

@XmlRootElement
public class RegexHeaderMatcher
implements HeaderMatcher {
    @XmlElement
    private String string;
    @XmlElement
    private HeaderTarget headerTarget;
    @XmlElement
    private RegexConfiguration regexConfig;
    @XmlTransient
    private Pattern pattern;

    public RegexHeaderMatcher() {
    }

    public RegexHeaderMatcher(String string, HeaderTarget headerTarget, RegexConfiguration regexConfig) {
        this.string = string;
        this.regexConfig = regexConfig;
        this.headerTarget = headerTarget;
        this.getPattern();
    }

    @Override
    public Optional<String> match(Sequence sequence) {
        Matcher matcher = this.getPattern().matcher(this.headerTarget.partToMatch(sequence));
        try {
            if (matcher.find()) {
                return Optional.of(matcher.group(this.regexConfig.getGroup()));
            }
            return Optional.empty();
        }
        catch (IllegalStateException | IndexOutOfBoundsException e) {
            return Optional.empty();
        }
    }

    private Pattern getPattern() {
        if (this.pattern == null) {
            String effectiveString = this.regexConfig.isQuotePattern() ? Pattern.quote(this.string) : this.string;
            this.pattern = this.regexConfig.isCaseSensitive() ? Pattern.compile(effectiveString) : Pattern.compile(effectiveString, 2);
        }
        return this.pattern;
    }

    public String getString() {
        return this.string;
    }

    public HeaderTarget getHeaderTarget() {
        return this.headerTarget;
    }

    public RegexConfiguration getRegexConfig() {
        return this.regexConfig;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.headerTarget == null ? 0 : this.headerTarget.hashCode());
        result = 31 * result + (this.regexConfig == null ? 0 : this.regexConfig.hashCode());
        result = 31 * result + (this.string == null ? 0 : this.string.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegexHeaderMatcher other = (RegexHeaderMatcher)obj;
        if (this.headerTarget != other.headerTarget) {
            return false;
        }
        if (this.regexConfig == null ? other.regexConfig != null : !this.regexConfig.equals(other.regexConfig)) {
            return false;
        }
        return !(this.string == null ? other.string != null : !this.string.equals(other.string));
    }
}

