/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.command;

import es.uvigo.ei.sing.yacli.command.option.FlagOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.sing_group.seda.cli.SedaCommand;
import org.sing_group.seda.cli.parameters.AddStringHeaderRenamerCliParameters;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.plugin.core.info.plugin.ReverseComplementSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.reverse_complement.ReverseComplementTransformationProvider;

public class ReverseComplementCommand
extends SedaCommand {
    public static final FlagOption OPTION_REVERSE = new FlagOption("reverse", "r", "Reverse sequences.");
    public static final FlagOption OPTION_COMPLEMENT = new FlagOption("complement", "c", "Complement sequences.");
    public static final FlagOption OPTION_RENAME_SEQUENCE_HEADERS = new FlagOption("rename-sequence-headers", "rsh", "Use this option to rename sequence headers using the specified configuration to add a prefix/suffix.");
    private AddStringHeaderRenamerCliParameters addStringHeader;

    public String getName() {
        return "reverse-complement";
    }

    public String getDescriptiveName() {
        return "Reverse Complement";
    }

    public String getDescription() {
        return "Convert the sequences into the reverse, complement, or reverse complement counterparts.";
    }

    @Override
    protected String getSedaGroup() {
        return ReverseComplementSedaPluginInfo.GROUP;
    }

    @Override
    protected List<Option<?>> createSedaOptions() {
        ArrayList options = new ArrayList();
        this.addStringHeader = new AddStringHeaderRenamerCliParameters(false);
        options.add((Option<?>)OPTION_REVERSE);
        options.add((Option<?>)OPTION_COMPLEMENT);
        options.add((Option<?>)OPTION_RENAME_SEQUENCE_HEADERS);
        options.addAll(this.addStringHeader.getOptionList());
        return options;
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        ReverseComplementTransformationProvider provider = new ReverseComplementTransformationProvider();
        provider.setReverseSequences(parameters.hasFlag((Option)OPTION_REVERSE));
        provider.setComplementSequences(parameters.hasFlag((Option)OPTION_COMPLEMENT));
        if (parameters.hasFlag((Option)OPTION_RENAME_SEQUENCE_HEADERS)) {
            provider.setHeaderRenamer(this.addStringHeader.getAddStringHeaderRenamer(parameters));
        }
        return provider;
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, ReverseComplementTransformationProvider.class);
    }
}

