/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.bio.consensus;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sing_group.seda.bio.consensus.SequencesGroupConsensus;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequenceBuilder;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.transformation.TransformationException;

public abstract class AbstractSequencesGroupAboveThresholdConsensus
implements SequencesGroupConsensus {
    private SequenceBuilder sequenceBuilder;
    protected double minimumPresence;
    protected boolean verbose;

    public AbstractSequencesGroupAboveThresholdConsensus(SequenceBuilder sequenceBuilder, double minimumPresence, boolean verbose) {
        this.minimumPresence = minimumPresence;
        this.sequenceBuilder = sequenceBuilder;
        this.verbose = verbose;
    }

    @Override
    public Sequence getConsensus(SequencesGroup sequencesGroup) {
        HashMap consensusMap = new HashMap();
        for (Object sequence : sequencesGroup.getSequences().collect(Collectors.toList())) {
            if (consensusMap.keySet().size() > 0 && consensusMap.keySet().size() != sequence.getLength()) {
                throw new TransformationException("All sequences must have the same length");
            }
            String string = sequence.getChain();
            for (int i = 0; i < string.length(); ++i) {
                Character charAt = Character.valueOf(string.charAt(i));
                consensusMap.putIfAbsent(i, new HashMap());
                ((Map)consensusMap.get(i)).putIfAbsent(charAt, 0);
                ((Map)consensusMap.get(i)).put(charAt, (Integer)((Map)consensusMap.get(i)).get(charAt) + 1);
            }
        }
        StringBuilder consensusChain = new StringBuilder();
        for (Map.Entry entry : consensusMap.entrySet()) {
            LinkedList<Character> maxCharacter = new LinkedList<Character>();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                double entryPresence = (double)((Integer)entry2.getValue()).intValue() / (double)sequencesGroup.getSequenceCount();
                if (!(entryPresence >= this.minimumPresence)) continue;
                maxCharacter.add((Character)entry2.getKey());
            }
            if (maxCharacter.size() == 0) {
                consensusChain.append(this.ambiguityCharacter());
                continue;
            }
            if (maxCharacter.size() == 1) {
                consensusChain.append(((Character)maxCharacter.get(0)).toString());
                continue;
            }
            consensusChain.append(this.solveAmbiguity(maxCharacter));
        }
        Sequence consensus = this.sequenceBuilder.of("consensus_" + sequencesGroup.getName(), "", consensusChain.toString(), Collections.emptyMap());
        return consensus;
    }

    protected abstract String solveAmbiguity(List<Character> var1);

    protected abstract String ambiguityCharacter();
}

