/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http.trafficlistener;

import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.http.trafficlistener.WiremockNetworkTrafficListener;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class CollectingNetworkTrafficListener
implements WiremockNetworkTrafficListener {
    private final StringBuilder requestBuilder = new StringBuilder();
    private final StringBuilder responseBuilder = new StringBuilder();
    private final Charset charset = Charset.forName("UTF-8");
    private final CharsetDecoder decoder = this.charset.newDecoder();

    @Override
    public void opened(Socket socket) {
    }

    @Override
    public void incoming(Socket socket, ByteBuffer bytes) {
        try {
            this.requestBuilder.append(this.decoder.decode(bytes));
        }
        catch (CharacterCodingException e) {
            LocalNotifier.notifier().error("Problem decoding network traffic", e);
        }
    }

    @Override
    public void outgoing(Socket socket, ByteBuffer bytes) {
        try {
            this.responseBuilder.append(this.decoder.decode(bytes));
        }
        catch (CharacterCodingException e) {
            LocalNotifier.notifier().error("Problem decoding network traffic", e);
        }
    }

    @Override
    public void closed(Socket socket) {
    }

    public String getAllRequests() {
        return this.requestBuilder.toString();
    }

    public String getAllResponses() {
        return this.responseBuilder.toString();
    }
}

