/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RenderCache;

public abstract class HandlebarsHelper<T>
implements Helper<T> {
    public static final String ERROR_PREFIX = "[ERROR: ";
    public static final String ERROR_SUFFIX = "]";

    protected String handleError(String message) {
        LocalNotifier.notifier().error(this.formatMessage(message));
        return this.formatMessage(message);
    }

    protected String handleError(String message, Throwable cause) {
        LocalNotifier.notifier().error(this.formatMessage(message), cause);
        return this.formatMessage(message);
    }

    protected String handleError(String message, String logExclusive, Throwable cause) {
        LocalNotifier.notifier().error(ERROR_PREFIX + message + " - " + logExclusive, cause);
        return this.formatMessage(message);
    }

    private String formatMessage(String message) {
        return ERROR_PREFIX + message + ERROR_SUFFIX;
    }

    protected static RenderCache getRenderCache(Options options) {
        return (RenderCache)options.get("renderCache", (Object)new RenderCache());
    }
}

