/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.splign.cli;

import es.uvigo.ei.sing.yacli.command.option.FileOption;
import es.uvigo.ei.sing.yacli.command.option.FlagOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.option.StringOption;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sing_group.seda.bedtools.cli.BedToolsCommandUtils;
import org.sing_group.seda.blast.cli.blast.BlastCommand;
import org.sing_group.seda.cli.ExternalSoftwareExecutionCommand;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.splign.execution.AbstractSplignCompartBinariesExecutor;
import org.sing_group.seda.splign.execution.DefaultSplignCompartBinariesExecutor;
import org.sing_group.seda.splign.execution.DockerSplignCompartBinariesExecutor;
import org.sing_group.seda.splign.execution.SplignCompartBinariesExecutor;
import org.sing_group.seda.splign.plugin.core.SplignCompartPipelineSedaPluginInfo;
import org.sing_group.seda.splign.transformation.provider.SplignCompartPipelineTransformationProvider;

public class SplignCompartPipelineCommand
extends ExternalSoftwareExecutionCommand {
    public static final StringOption OPTION_SPLIGN_COMPART_DOCKER_MODE = new StringOption(SOFTWARE_EXECUTION_CATEGORY, "splign-compart-docker-mode", "splign-compart-dk", "The Splign/ProCompart docker image. By default, the official SEDA image is used. If you provide a custom image, it should have the splign and compart commands available in the path.", true, true);
    public static final StringOption OPTION_SPLIGN_COMPART_LOCAL_MODE = new StringOption(SOFTWARE_EXECUTION_CATEGORY, "splign-compart-local-mode", "splign-compart-lc", "The directory that contains the Splign/Compart binaries. Leave it empty if they are in the path. Check the SEDA manual to see how to obtain them.", true, true);
    public static final FileOption OPTION_EXTERNAL_QUERY_FILE = new FileOption("query-file", "qf", "The CDS query file (nucleotides).", true, true);
    public static final FlagOption OPTION_CONCATENATE_EXONS = new FlagOption("concat-exons", "ce", "If the concatenate exons option is checked, then adjacent exons will be concatenated. Therefore, if an annotation is obtained for every exon of a given gene, the resulting sequence will be the complete CDS.");
    public static final StringOption OPTION_BLAST_DOCKER_MODE = new StringOption(SOFTWARE_EXECUTION_CATEGORY, "blast-docker-mode", "blast-dk", "The BLAST docker image. By default, the official SEDA image for BLAST is used. If you provide a custom image, it should have the BLAST commands available in the path.", true, true);
    public static final StringOption OPTION_BLAST_LOCAL_MODE = new StringOption(SOFTWARE_EXECUTION_CATEGORY, "blast-local-mode", "blast-lc", "The directory that contains the BLAST binaries. Leave it empty if they are in the path.", true, true);
    public static final StringOption OPTION_BEDTOOLS_DOCKER_MODE = new StringOption(SOFTWARE_EXECUTION_CATEGORY, "bedtools-docker-mode", "bedtools-dk", "The bedtools docker image. By default, the official SEDA image for bedtools is used. If you provide a custom image, it should have the bedtools command available in the path.", true, true);
    public static final StringOption OPTION_BEDTOOLS_LOCAL_MODE = new StringOption(SOFTWARE_EXECUTION_CATEGORY, "bedtools-local-mode", "bedtools-lc", "The bedtools binary file. If the bedtools binary is in the path, then this can be empty.", true, true);

    public String getName() {
        return "splign-compart";
    }

    public String getDescriptiveName() {
        return "Splign/Compart Pipeline";
    }

    public String getDescription() {
        return "Obtain CDS annotations with Splign/Compart, using selected files and a file with reference CDS sequences.";
    }

    @Override
    protected String getSedaGroup() {
        return SplignCompartPipelineSedaPluginInfo.GROUP;
    }

    @Override
    protected List<Option<?>> getMandatoryOptions() {
        return Arrays.asList(OPTION_EXTERNAL_QUERY_FILE);
    }

    @Override
    protected List<Option<?>> getLocalOptionsList() {
        return Arrays.asList(OPTION_SPLIGN_COMPART_LOCAL_MODE, OPTION_BLAST_LOCAL_MODE, OPTION_BEDTOOLS_LOCAL_MODE);
    }

    @Override
    protected Map<Option<?>, String> getLocalOptionsToEnablePropertyMap() {
        return SplignCompartPipelineCommand.fromLists(this.getLocalOptionsList(), Arrays.asList("seda.local.execution.enabled.spligncompart", "seda.local.execution.enabled.blast", "seda.local.execution.enabled.bedtools"));
    }

    @Override
    protected List<Option<?>> createExternalSedaOptions() {
        return Arrays.asList(OPTION_SPLIGN_COMPART_LOCAL_MODE, OPTION_SPLIGN_COMPART_DOCKER_MODE, OPTION_EXTERNAL_QUERY_FILE, OPTION_CONCATENATE_EXONS, OPTION_BLAST_LOCAL_MODE, OPTION_BLAST_DOCKER_MODE, OPTION_BEDTOOLS_LOCAL_MODE, OPTION_BEDTOOLS_DOCKER_MODE);
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        SplignCompartPipelineTransformationProvider provider = new SplignCompartPipelineTransformationProvider();
        provider.setQueryFile(this.getExistingFile(parameters, OPTION_EXTERNAL_QUERY_FILE));
        provider.setConcatenateExons(parameters.hasFlag((Option)OPTION_CONCATENATE_EXONS));
        provider.setSplignCompartBinariesExecutor(Optional.of(this.getSplignCompartBinariesExecutor(parameters)));
        provider.setBlastBinariesExecutor(Optional.of(BlastCommand.getBlastBinariesExecutor((Parameters)parameters, (StringOption)OPTION_BLAST_LOCAL_MODE, (StringOption)OPTION_BLAST_DOCKER_MODE)));
        provider.setBedToolsBinariesExecutor(Optional.of(BedToolsCommandUtils.getBedToolsBinariesExecutor((Parameters)parameters, (StringOption)OPTION_BEDTOOLS_LOCAL_MODE, (StringOption)OPTION_BEDTOOLS_DOCKER_MODE)));
        return provider;
    }

    private SplignCompartBinariesExecutor getSplignCompartBinariesExecutor(Parameters parameters) {
        SplignCompartPipelineCommand.validateSingleExecutionMode(parameters, OPTION_SPLIGN_COMPART_LOCAL_MODE, OPTION_SPLIGN_COMPART_DOCKER_MODE, " for Splign/Compart");
        AbstractSplignCompartBinariesExecutor executor = new DockerSplignCompartBinariesExecutor(DockerSplignCompartBinariesExecutor.getDefaultDockerImage());
        if (parameters.hasOption((Option)OPTION_SPLIGN_COMPART_LOCAL_MODE)) {
            File splignCompartDirectory = new File(parameters.getSingleValueString((Option)OPTION_SPLIGN_COMPART_LOCAL_MODE));
            if (splignCompartDirectory.isDirectory()) {
                executor = new DefaultSplignCompartBinariesExecutor(splignCompartDirectory);
            } else {
                SplignCompartPipelineCommand.formattedValidationError("The specified Splign/Compart directory does not exist or it is not a directory.");
            }
        }
        if (parameters.hasOption((Option)OPTION_SPLIGN_COMPART_DOCKER_MODE)) {
            executor = new DockerSplignCompartBinariesExecutor((String)parameters.getSingleValue((Option)OPTION_SPLIGN_COMPART_DOCKER_MODE));
        }
        return executor;
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, SplignCompartPipelineTransformationProvider.class);
    }
}

