/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cga.gui;

import java.util.Optional;
import javax.swing.JOptionPane;
import org.sing_group.seda.cga.execution.CgaBinariesExecutor;
import org.sing_group.seda.cga.execution.DefaultDockerCgaBinariesExecutor;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.gui.execution.AbstractDockerExecutionConfigurationPanel;

public class DockerExecutionConfigurationPanel
extends AbstractDockerExecutionConfigurationPanel<CgaBinariesExecutor> {
    private static final long serialVersionUID = 1L;

    public DockerExecutionConfigurationPanel() {
        super(DefaultDockerCgaBinariesExecutor.getDefaultDockerImage());
    }

    @Override
    public Optional<CgaBinariesExecutor> getBinariesExecutor() {
        String selectedDockerImage = this.getSelectedDockerImage();
        if (selectedDockerImage.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new DefaultDockerCgaBinariesExecutor(selectedDockerImage));
    }

    @Override
    protected void checkBinary() {
        try {
            Optional<CgaBinariesExecutor> executor = this.getBinariesExecutor();
            if (executor.isPresent()) {
                this.getBinariesExecutor().get().checkBinary();
                JOptionPane.showMessageDialog(this.getParentForDialogs(), "CGA binaries checked successfully.", "Check CGA binaries", 1);
            }
        }
        catch (BinaryCheckException e) {
            JOptionPane.showMessageDialog(this.getParentForDialogs(), "Error checking CGA binaries: " + e.getCommand() + ".", "Error checking CGA", 0);
        }
    }
}

