/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.clustalomega.gui;

import java.io.File;
import java.nio.file.Paths;
import java.util.Optional;
import javax.swing.JOptionPane;
import org.sing_group.gc4s.input.filechooser.SelectionMode;
import org.sing_group.seda.clustalomega.execution.ClustalOmegaBinariesExecutor;
import org.sing_group.seda.clustalomega.execution.DefaultClustalOmegaBinariesExecutor;
import org.sing_group.seda.clustalomega.plugin.core.ClustalOmegaAlignmentSedaPluginInfo;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.gui.execution.AbstractSystemBinaryExecutionConfigurationPanel;

public class SystemBinaryExecutionConfigurationPanel
extends AbstractSystemBinaryExecutionConfigurationPanel<ClustalOmegaBinariesExecutor> {
    private static final long serialVersionUID = 1L;
    private static final String HELP_CLUSTAL_OMEGA_PATH = ClustalOmegaAlignmentSedaPluginInfo.PARAM_LOCAL_MODE_HELP_GUI;

    public SystemBinaryExecutionConfigurationPanel() {
        super(SelectionMode.FILES, "Custal Omega executable path: ", HELP_CLUSTAL_OMEGA_PATH);
    }

    @Override
    protected void checkBinary() {
        try {
            this.getBinariesExecutor().get().checkBinary();
            JOptionPane.showMessageDialog(this.getParentForDialogs(), "Clustal Omega checked successfully.", "Check Clustal Omega", 1);
        }
        catch (BinaryCheckException e) {
            JOptionPane.showMessageDialog(this.getParentForDialogs(), "Error checking Clustal Omega: " + e.getCommand() + ".", "Error checking Clustal Omega", 0);
        }
    }

    @Override
    public Optional<ClustalOmegaBinariesExecutor> getBinariesExecutor() {
        return Optional.of(new DefaultClustalOmegaBinariesExecutor(this.getClustalOmegaPath()));
    }

    private File getClustalOmegaPath() {
        File selectedBinaryPath = this.getSelectedBinaryPath();
        if (selectedBinaryPath != null) {
            return selectedBinaryPath;
        }
        return Paths.get(DefaultClustalOmegaBinariesExecutor.getClustalOmegaBinaryFileName(), new String[0]).toFile();
    }
}

