package es.uvigo.esei.daa.entities;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;


import org.junit.Test;

import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;

public class PetUnitTest {
	@Test
	public void testPetIntStringStringStringInt() {
		final int id = 1;
		final String name = "Tor";
		final String tipo = "Perro";
		final String raza = "pomerania";
		final int idPersona = 1;
		
		final Pet pet = new Pet(id, name, tipo, raza, idPersona);
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo(name)));
		assertThat(pet.getTipo(), is(equalTo(tipo)));
		assertThat(pet.getRaza(), is(equalTo(raza)));
		assertThat(pet.getIdPersona(), is(equalTo(idPersona)));
	}

	@Test(expected = NullPointerException.class)
	public void testPetIntStringStringStringIntNullName() {
		new Pet(1, null, "Perro", "pomerania", 1);
	}
	
	@Test(expected = NullPointerException.class)
	public void testPetIntStringStringStringIntNullTipo() {
		new Pet(1, "Tor", null, "pomerania", 1);
	}

	@Test
	public void testSetName() {
		final int id = 1;
		final String tipo = "Perro";
		final String raza = "pomerania";
		final int idPersona = 1;
		
		final Pet pet = new Pet(id, "Tor", tipo, raza, idPersona);
		pet.setName("Loki");
		
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo("Loki")));
		assertThat(pet.getTipo(), is(equalTo(tipo)));
		assertThat(pet.getRaza(), is(equalTo(raza)));
		assertThat(pet.getIdPersona(), is(equalTo(idPersona)));
	}

	@Test(expected = NullPointerException.class)
	public void testSetNullName() {
		final Pet pet = new Pet(1, "Tor", "Perro", "pomerania", 1);
		
		pet.setName(null);
	}

	@Test
	public void testSetTipo() {
		final int id = 1;
		final String name = "Tor";
		final String raza = "pomerania";
		final int idPersona = 1;
		
		final Pet pet = new Pet(id, name, "Perro", raza, idPersona);
		pet.setTipo("Gato");
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo(name)));
		assertThat(pet.getTipo(), is(equalTo("Gato")));
		assertThat(pet.getRaza(), is(equalTo(raza)));
		assertThat(pet.getIdPersona(), is(equalTo(idPersona)));
	}

	@Test(expected = NullPointerException.class)
	public void testSetNullTipo() {
		final Pet pet = new Pet(1, "Tor", "Perro", "pomerania", 1);
		
		pet.setTipo(null);
	}

	@Test
	public void testEqualsObject() {
		final Pet petA = new Pet(1, "Name A", "Tipo A", "Raza A",1);
		final Pet petB = new Pet(1, "Name B", "Tipo B", "Raza B",1);
		System.out.println(petA);
		System.out.println(petB);
		assertTrue(petA.equals(petB));
	}

	@Test
	public void testEqualsHashcode() {
		EqualsVerifier.forClass(Pet.class)
			.withIgnoredFields("name", "tipo", "raza","idPersona")
			.suppress(Warning.STRICT_INHERITANCE)
			.suppress(Warning.NONFINAL_FIELDS)
		.verify();
	}
}

