package es.uvigo.esei.daa.dataset;

import static java.util.Arrays.binarySearch;
import static java.util.Arrays.stream;

import java.util.Arrays;
import java.util.function.Predicate;

import es.uvigo.esei.daa.entities.Pet;

public final class PetDataset {
	private PetDataset() {}
	
	public static Pet[] pet() {
		return new Pet[] {
			new Pet(1, "Cachorrito", "Perro", "bordercollie", 1),
			new Pet(2, "Toby", "Perro", "beagle", 1),
			new Pet(3, "Tobyy", "Perroo", "beaglee", 1)
		};
	}
	
	public static Pet[] petWithout(int ... ids) {
		Arrays.sort(ids);
		
		final Predicate<Pet> hasValidId = pet ->
			binarySearch(ids, pet.getId()) < 0;
		
		return stream(pet())
			.filter(hasValidId)
		.toArray(Pet[]::new);
	}
	
	public static Pet pet(int id) {
		return stream(pet())
			.filter(pet -> pet.getId() == id)
			.findAny()
		.orElseThrow(IllegalArgumentException::new);
	}
	
	public static int existentId() {
		return 1;
	}
	
	public static int nonExistentId() {
		return 1234;
	}

	public static Pet existentPet() {
		return pet(existentId());
	}
	
	public static Pet nonExistentPet() {
		return new Pet(nonExistentId(), "Pulgas", "Perro", "labrador", 1);
	}
	
	public static String newName() {
		return "Tor";
	}
	
	public static String newTipo() {
		return "Perro";
	}
	public static String newRaza() {
		return "pomerania";
	}
	public static int newIdPersona() {
		return 1;
	}
	
	public static Pet newPet() {
		return new Pet(pet().length +1, newName(), newTipo(), newRaza(), newIdPersona());
	}
}

