package es.uvigo.esei.daa.entities;

import static java.util.Objects.requireNonNull;
/**
 * An entity that represents a person.
 * 
 * @author Victor Fernandez Varela
 */
public class Pet {
		private int id;
		private String name;
		private String tipo;
		private String raza;
		private int idPersona;
		
		// Constructor needed for the JSON conversion
		Pet() {}
		
		/**
		 * Constructs a new instance of {@link Pet}.
		 *
		 * @param id identificador mascota
		 * @param name nombre mascota.
		 * @param tipo tipo mascota.
		 * @param raza raza mascota.
		 * @param idPersona identificador del propietario de la mascota.
		 */
		public Pet(int id, String name, String tipo, String raza, int idPersona) {
			this.id = id;
			this.setName(name);
			this.setTipo(tipo);
			this.setRaza(raza);
			this.idPersona = idPersona;
		}
		
		/**
		 * Retorna el identificador de la mascota.
		 * 
		 * @return el identificador de la mascota.
		 */
		public int getId() {
			return id;
		}

		/**
		 * Retorna el nombre de la mascota.
		 * 
		 * @return el nombre de la mascota.
		 */
		public String getName() {
			return name;
		}
		/**
		 * Retorna el tipo de la mascota.
		 * 
		 * @return el tipo de la mascota.
		 */
		public String getTipo() {
			return tipo;
		}
		/**
		 * Retorna el raza de la mascota.
		 * 
		 * @return el raza de la mascota.
		 */
		public String getRaza() {
			return raza;
		}
		/**
		 * Retorna el id del propietario de esa mascota.
		 * 
		 * @return el id del propietario de esa mascota.
		 */
		public int getIdPersona() {
			return idPersona;
		}

		/**
		 * Set el nombre de la mascota
		 * 
		 * @param name nombre de la nueva mascota
		 * @throws NullPointerException if the {@code name} is {@code null}.
		 */
		public void setName(String name) {
			this.name = requireNonNull(name, "Name no puede estar vacia");
		}
		/**
		 * Set el tipo de la mascota
		 * 
		 * @param tipo tipo de la mascota
		 * @throws NullPointerException if the {@code tipo} is {@code null}.
		 */
		public void setTipo(String tipo) {
			this.tipo = requireNonNull(tipo, "Tipo no puede estar vacia");
		}
		/**
		 * Set la raza de la mascota
		 * 
		 * @param raza raza de la nueva mascota
		 * @throws NullPointerException if the {@code raza} is {@code null}.
		 */
		public void setRaza(String raza) {
			this.raza = requireNonNull(raza, "Raza no puede estar vacia");
		}
		/**
		 * Set id del propietario de la mascota
		 * 
		 * @param idPersona idPersona propietario de la mascota
		 * @throws NullPointerException if the {@code idPersona} is {@code null}.
		 */
		public void setIdPersona(int idPersona) {
			this.idPersona = requireNonNull(idPersona, "Id de la persona no puede estar vacia");
		}
		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result + id;
			return result;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (!(obj instanceof Pet))
				return false;
			Pet other = (Pet) obj;
			if (id != other.id)
				return false;
			return true;
		}

		
	

}
