package es.uvigo.esei.daa.rest;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import es.uvigo.esei.daa.dao.DAOException;
import es.uvigo.esei.daa.dao.PeopleDAO;
import es.uvigo.esei.daa.dao.PetsDAO;
import es.uvigo.esei.daa.entities.Person;
import es.uvigo.esei.daa.entities.Pet;

@Path("/people/{idOwner}/pets")
@Produces(MediaType.APPLICATION_JSON)
public class PetsResource {
	private final static Logger LOG = Logger.getLogger(PeopleResource.class.getName());
	
	private final PetsDAO petDAO;
	

	public PetsResource() {
		this(new PetsDAO());
	}
	
	
	PetsResource(PetsDAO petsDAO) {
		this.petDAO = petsDAO;
	}

	@GET
	public Response getPets( @PathParam("idOwner") int id ) {
		try {
			return Response.ok(this.petDAO.list(id)).build();
		} catch (DAOException e) {
			LOG.log(Level.SEVERE, "Error listing pets", e);
			return Response.serverError().entity(e.getMessage()).build();
		}
	}

	@POST
	public Response add(@FormParam("name") String name, @PathParam("idOwner") int owner) {
		try {
			final Pet newPet = this.petDAO.add(name, owner);

			return Response.ok(newPet).build();
		} catch (IllegalArgumentException iae) {
			LOG.log(Level.FINE, "Invalid pet id in add method", iae);

			return Response.status(Response.Status.BAD_REQUEST).entity(iae.getMessage()).build();
		} catch (DAOException e) {
			LOG.log(Level.SEVERE, "Error adding a pet", e);

			return Response.serverError().entity(e.getMessage()).build();
		}
	}

	
	@PUT
	@Path("/{idPet}")
	public Response modify(@PathParam("idPet") int id, @FormParam("name") String name, @PathParam("idOwner") int idOwner) {
		try {
			Person owner = new PeopleDAO().get(idOwner);
			final Pet modifiedPet = new Pet(id, name, owner);
			this.petDAO.modify(modifiedPet);

			return Response.ok(modifiedPet).build();
		} catch (NullPointerException npe) {
			final String message = String.format("Invalid data for pet ");

			LOG.log(Level.FINE, message);

			return Response.status(Response.Status.BAD_REQUEST).entity(message).build();
		} catch (IllegalArgumentException iae) {
			LOG.log(Level.FINE, "Invalid pet id in modify method", iae);

			return Response.status(Response.Status.BAD_REQUEST).entity(iae.getMessage()).build();
		} catch (DAOException e) {
			LOG.log(Level.SEVERE, "Error modifying a pet", e);

			return Response.serverError().entity(e.getMessage()).build();
		}
	}
	
	
	@DELETE
	@Path("/{idPet}")
	public Response delete(@PathParam("idPet") String idPet) {
		try {
			this.petDAO.delete(Integer.parseInt(idPet));

			return Response.ok(Integer.parseInt(idPet)).build();
		} catch (IllegalArgumentException iae) {
			LOG.log(Level.FINE, "Invalid pet id in delete method", iae);

			return Response.status(Response.Status.BAD_REQUEST).entity(iae.getMessage()).build();
		} catch (DAOException e) {
			LOG.log(Level.SEVERE, "Error deleting a pet", e);

			return Response.serverError().entity(e.getMessage()).build();
		}
	}
	

}
