package es.uvigo.esei.daa.entities;

import static java.util.Objects.requireNonNull;

public class Pet {

	private int id;
	private String name;
	private Person owner;
	
	
	
	Pet() {}
	
	

	public Pet(int id, String name, Person owner) {
		this.id = id;
		this.setName(name);
		this.setOwner(owner);
	}
	
	

	public int getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = requireNonNull(name, "Name can't be null");
	}

	public Person getOwner() {
		return owner;
	}

	public void setOwner(Person owner) {
		this.owner = requireNonNull(owner, "Owner can't be null");
	}
	
	

	@Override
	public int hashCode() {
		final int prime = 41;
		int result = 1;
		result = prime * result + id;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof Pet))
			return false;
		Pet other = (Pet) obj;
		if (id != other.id)
			return false;
		return true;
	}
	
	
	
	
	
	
}
