package es.uvigo.esei.daa.entities;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.*;

import org.junit.Test;

import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;

public class PetUnitTest {

	@Test
	public void testPetIntStringPerson() {
		final int idPerson = 1;
		final String namePerson = "John";
		final String surnamePerson = "Doe";
		
		final Person owner = new Person(1, namePerson, surnamePerson);
		
		final int idPet = 1;
		final String namePet = "Mascota";
		
		final Pet pet = new Pet (idPet, namePet, owner);
		
		assertThat(pet.getId(), is(equalTo(idPet)));
		assertThat(pet.getName(), is(equalTo(namePet)));
		assertThat(pet.getOwner().getId(), is(equalTo(idPerson)));
		assertThat(pet.getOwner().getName(), is(equalTo(namePerson)));
		assertThat(pet.getOwner().getSurname(), is(equalTo(surnamePerson)));
		
	}
	
	@Test(expected = NullPointerException.class)
	public void testPetNullName() {
		new Pet(1, null, new Person (1, "John", "Doe") );
	}
	
	@Test(expected = NullPointerException.class)
	public void testPetNullOwner() {
		new Pet(1, "Mascota", null);
	}
	
	@Test
	public void testSetName() {
		final int id = 1;
		final Person owner = new Person (1, "John", "Doe");
		
		final Pet pet = new Pet(id, "Mascota", owner);
		pet.setName("Pet");
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo("Pet")));
		assertThat(pet.getOwner().getId(), is(equalTo(1)));
		assertThat(pet.getOwner().getName(), is(equalTo("John")));
		assertThat(pet.getOwner().getSurname(), is(equalTo("Doe")));
	}

	@Test(expected = NullPointerException.class)
	public void testSetNullName() {
		final int id = 1;
		final Person owner = new Person (1, "John", "Doe");
		
		final Pet pet = new Pet(id, "Mascota", owner);
		pet.setName(null);
	}

	@Test
	public void testSetOwner() {
		final int id = 1;
		final Person owner = new Person (1, "John", "Doe");
		final Person ownerSet = new Person (2, "Antonio", "Perez");
		
		final Pet pet = new Pet(id, "Mascota", owner);
		pet.setOwner(ownerSet);
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo("Mascota")));
		assertThat(pet.getOwner().getId(), is(equalTo(2)));
		assertThat(pet.getOwner().getName(), is(equalTo("Antonio")));
		assertThat(pet.getOwner().getSurname(), is(equalTo("Perez")));
	}

	@Test(expected = NullPointerException.class)
	public void testSetNullSurname() {
		final int id = 1;
		final Person owner = new Person (1, "John", "Doe");
		
		final Pet pet = new Pet(id, "Mascota", owner);
		pet.setOwner(null);
	}

	@Test
	public void testEqualsObject() {
		final int id = 1;
		final Person owner = new Person (1, "John", "Doe");
		
		final Pet pet1 = new Pet(id, "Mascota", owner);
		final Pet pet2 = new Pet(id, "Mascota", owner);
		
		assertTrue(pet1.equals(pet2));
	}

	@Test
	public void testEqualsHashcode() {
		EqualsVerifier.forClass(Pet.class)
			.withIgnoredFields("name", "owner")
			.suppress(Warning.STRICT_INHERITANCE)
			.suppress(Warning.NONFINAL_FIELDS)
		.verify();
	}

}
