var PetView = (function() {
	var dao;
	
	// Referencia a this que permite acceder a las funciones públicas desde las funciones de jQuery.
	var self;
	
	var formId = 'Pet-form';
	var listId = 'Pet-list';
	var formQuery = '#' + formId;
	var listQuery = '#' + listId;
	
	function PetView(PetDao, formContainerId, listContainerId) {
		dao = PetDao;
		self = this;
		
		insertPetForm($('#' + formContainerId));
		insertPetList($('#' + listContainerId));
		
		this.init = function() {
			dao.listPet(function(Pet) {
				$.each(Pet, function(key, pet) {
					appendToTable(pet);
				});
			});
			
			// La acción por defecto de enviar formulario (submit) se sobreescribe
			// para que el envío sea a través de AJAX
			$(formQuery).submit(function(event) {
				var pet = self.getpetInForm();
				
				if (self.isEditing()) {
					dao.modifypet(pet,
						function(pet) {
							$('#pet-' + pet.idPet + ' td.name').text(pet.name);
							$('#pet-' + pet.idPet + ' td.idMaster').text(pet.idMaster);
							self.resetForm();
						},
						showErrorMessage,
						self.enableForm
					);
				} else {
					dao.addpet(pet,
						function(pet) {
							appendToTable(pet);
							self.resetForm();
						},
						showErrorMessage,
						self.enableForm
					);
				}
				
				return false;
			});
			
			$('#btnClear').click(this.resetForm);
		};

		this.getpetInForm = function() {
			var form = $(formQuery);
			return {
				'id': form.find('input[name="id"]').val(),
				'name': form.find('input[name="name"]').val(),
				'idMaster': form.find('input[name="idMaster"]').val()
			};
		};

		this.getpetInRow = function(id) {
			var row = $('#pet-' + id);

			if (row !== undefined) {
				return {
					'id': id,
					'name': row.find('td.name').text(),
					'idMaster': row.find('td.idMaster').text()
				};
			} else {
				return undefined;
			}
		};
		
		this.editpet = function(id) {
			var row = $('#pet-' + id);

			if (row !== undefined) {
				var form = $(formQuery);
				
				form.find('input[name="id"]').val(id);
				form.find('input[name="name"]').val(row.find('td.name').text());
				form.find('input[name="idMaster"]').val(row.find('td.idMaster').text());
				
				$('input#btnSubmit').val('Modificar');
			}
		};
		
		this.deletepet = function(id) {
			if (confirm('Está a punto de eliminar a una pet. ¿Está seguro de que desea continuar?')) {
				dao.deletepet(id,
					function() {
						$('tr#pet-' + id).remove();
					},
					showErrorMessage
				);
			}
		};

		this.isEditing = function() {
			return $(formQuery + ' input[name="id"]').val() != "";
		};

		this.disableForm = function() {
			$(formQuery + ' input').prop('disabled', true);
		};

		this.enableForm = function() {
			$(formQuery + ' input').prop('disabled', false);
		};

		this.resetForm = function() {
			$(formQuery)[0].reset();
			$(formQuery + ' input[name="id"]').val('');
			$('#btnSubmit').val('Crear');
		};
	};
	
	var insertPetList = function(parent) {
		parent.append(
			'<table id="' + listId + '" class="table">\
				<thead>\
					<tr class="row">\
						<th class="col-sm-4">Nombre</th>\
						<th class="col-sm-5">Id Master</th>\
						<th class="col-sm-3">&nbsp;</th>\
					</tr>\
				</thead>\
				<tbody>\
				</tbody>\
			</table>'
		);
	};

	var insertPetForm = function(parent) {
		parent.append(
			'<form id="' + formId + '" class="mb-5 mb-10">\
				<input name="id" type="hidden" value=""/>\
				<div class="row">\
					<div class="col-sm-4">\
						<input name="name" type="text" value="" placeholder="Nombre" class="form-control" required/>\
					</div>\
					<div class="col-sm-5">\
						<input name="idMaster" type="text" value="" placeholder="Apellido" class="form-control" required/>\
					</div>\
					<div class="col-sm-3">\
						<input id="btnSubmit" type="submit" value="Crear" class="btn btn-primary" />\
						<input id="btnClear" type="reset" value="Limpiar" class="btn" />\
					</div>\
				</div>\
			</form>'
		);
	};

	var createpetRow = function(pet) {
		return '<tr id="pet-'+ pet.idPet +'" class="row">\
			<td class="name col-sm-4">' + pet.name + '</td>\
			<td class="idMaster col-sm-5">' + pet.idMaster + '</td>\
			<td class="col-sm-3">\
				<a class="edit btn btn-primary" href="#">Editar</a>\
				<a class="delete btn btn-warning" href="#">Eliminar</a>\
			</td>\
		</tr>';
	};

	var showErrorMessage = function(jqxhr, textStatus, error) {
		alert(textStatus + ": " + error);
	};

	var addRowListeners = function(pet) {
		$('#pet-' + pet.idPet + ' a.edit').click(function() {
			self.editpet(pet.idPet);
		});
		
		$('#pet-' + pet.idPet + ' a.delete').click(function() {
			self.deletepet(pet.idPet);
		});
	};

	var appendToTable = function(pet) {
		$(listQuery + ' > tbody:last')
			.append(createpetRow(pet));
		addRowListeners(pet);
	};
	
	return PetView;
})();