package es.uvigo.esei.daa.rest;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import es.uvigo.esei.daa.dao.DAOException;
import es.uvigo.esei.daa.dao.PeopleDAO;
import es.uvigo.esei.daa.dao.PetDAO;
import es.uvigo.esei.daa.entities.Person;
import es.uvigo.esei.daa.entities.Pet;



@Path("/pet")
@Produces(MediaType.APPLICATION_JSON)
public class PetResource {
	
	private final static Logger LOG = Logger.getLogger(PeopleResource.class.getName());
	
	private final PetDAO dao;
	
	
	public PetResource() {
		this(new PetDAO());
	}
	
	public PetResource(PetDAO dao) {
		this.dao = dao;
	}

	
	
	
	
	@GET
	@Path("/{idPet}")
	public Response get(
		@PathParam("idPet") int idPet
	) {
		try {
			final Pet pet = this.dao.get(idPet);
			
			return Response.ok(pet).build();
			
		} catch (IllegalArgumentException iae) {
			LOG.log(Level.FINE, "Invalid pet id in get method", iae);
			
			return Response.status(Response.Status.BAD_REQUEST)
				.entity(iae.getMessage())
			.build();
		} catch (DAOException e) {
			LOG.log(Level.SEVERE, "Error getting a pet", e);
			
			return Response.serverError()
				.entity(e.getMessage())
			.build();
		}
	}
	
	
	@GET
	public Response list() {
		try {
			return Response.ok(this.dao.list()).build();
		} catch (DAOException e) {
			LOG.log(Level.SEVERE, "Error listing pets", e);
			return Response.serverError().entity(e.getMessage()).build();
		}
	}
	
	
	
	
	
	@POST
	public Response add(
		@FormParam("name") String name, 
		@FormParam("idMaster") int idMaster
	) {
		try {
			final Pet newPet = this.dao.add(name, idMaster);
			
			return Response.ok(newPet).build();
		} catch (IllegalArgumentException iae) {
			LOG.log(Level.FINE, "Invalid pet id in add method", iae);
			
			return Response.status(Response.Status.BAD_REQUEST)
				.entity(iae.getMessage())
			.build();
		} catch (DAOException e) {
			LOG.log(Level.SEVERE, "Error adding a pet", e);
			
			return Response.serverError()
				.entity(e.getMessage())
			.build();
		}
	}


	
	@PUT
	@Path("/{idPet}")
	public Response modify(
		@PathParam("idPet") int idPet, 
		@FormParam("name") String name, 
		@FormParam("idMaster") int idMaster
	) {
		try {
			final Pet modifiedPet = new Pet(idPet, name, idMaster);
			this.dao.modify(modifiedPet);
			
			return Response.ok(modifiedPet).build();
		} catch (NullPointerException npe) {
			final String message = String.format("Invalid data for pet (name: %s, idMaster: %s)", name, idMaster);
			
			LOG.log(Level.FINE, message);
			
			return Response.status(Response.Status.BAD_REQUEST)
				.entity(message)
			.build();
		} catch (IllegalArgumentException iae) {
			LOG.log(Level.FINE, "Invalid idPet in modify method", iae);
			
			return Response.status(Response.Status.BAD_REQUEST)
				.entity(iae.getMessage())
			.build();
		} catch (DAOException e) {
			LOG.log(Level.SEVERE, "Error modifying a Pet", e);
			
			return Response.serverError()
				.entity(e.getMessage())
			.build();
		}
	}


	@DELETE
	@Path("/{idPet}")
	public Response delete(
		@PathParam("idPet") int idPet
	) {
		try {
			this.dao.delete(idPet);
			
			return Response.ok(idPet).build();
		} catch (IllegalArgumentException iae) {
			LOG.log(Level.FINE, "Invalid idPet in delete method", iae);
			
			return Response.status(Response.Status.BAD_REQUEST)
				.entity(iae.getMessage())
			.build();
		} catch (DAOException e) {
			LOG.log(Level.SEVERE, "Error deleting a Pet", e);
			
			return Response.serverError()
				.entity(e.getMessage())
			.build();
		}
	}
	
	
	
	
	
	
	
}
