var PetDAO = (function() {
	var resourcePath = "rest/pet/";
	var requestByAjax = function(data, done, fail, always) {
		done = typeof done !== 'undefined' ? done : function() {};
		fail = typeof fail !== 'undefined' ? fail : function() {};
		always = typeof always !== 'undefined' ? always : function() {};
		
		$.ajax(data)
			.done(done)
			.fail(fail)
			.always(always);
	};
	
	function PetDAO() {
		this.listPet = function(done, fail, always) {
			requestByAjax({
				url: resourcePath,
				type: 'GET'
			}, done, fail, always);
		};
		
		this.addPet = function(Pet, done, fail, always) {
			requestByAjax({
				url: resourcePath,
				type: 'POST',
				data: Pet
			}, done, fail, always);
		};
		
		this.modifyPet = function(Pet, done, fail, always) {
			requestByAjax({
				url: resourcePath + Pet.id,
				type: 'PUT',
				data: Pet
			}, done, fail, always);
		};
		
		this.deletePet = function(id, done, fail, always) {
			requestByAjax({
				url: resourcePath + id,
				type: 'DELETE',
			}, done, fail, always);
		};
	}
	
	return PetDAO;
})();