package es.uvigo.esei.daa.entities;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;



public class PetUnitTest {
	
	@Test
	public void testConstructorWhithParams() {
		final int idPet = 1;
		final String name = "Tallulah";
		final int idMaster = 2;
		
		
		final Pet pet = new Pet(idPet,name,idMaster);
		
		assertThat(pet.getIdPet(), is(idPet));
		assertThat(pet.getName(), is(name));
		assertThat(pet.getIdMaster(), is(idMaster));
	}
	
	
	@Test(expected = NullPointerException.class)
	public void testConstructorNullName() {
		new Pet(1, null, 2);
	}
	

	@Test
	public void testSetName() {
		final int idPet = 1;
		final String name = "Tallulah";
		final int idMaster = 2;
		
		
		final Pet pet = new Pet(idPet,name,idMaster);
		pet.setName("Jimminy");
		
		assertThat(pet.getIdPet(), is(idPet));
		assertThat(pet.getName(), is("Jimminy"));
		assertThat(pet.getIdMaster(), is(idMaster));
	}

	@Test(expected = NullPointerException.class)
	public void testSetNullName() {
		final int idPet = 1;
		final String name = "Tallulah";
		final int idMaster = 2;
		
		final Pet pet = new Pet(idPet,name,idMaster);
		
		pet.setName(null);
	}

	@Test
	public void testSetIdPet() {
		final int idPet = 1;
		final String name = "Tallulah";
		final int idMaster = 2;
		
		
		final Pet pet = new Pet(idPet,name,idMaster);
		pet.setIdPet(4);;
		
		assertThat(pet.getIdPet(), is(4));
		assertThat(pet.getName(), is(name));
		assertThat(pet.getIdMaster(), is(idMaster));
	}
	
	@Test
	public void testSetIdMaster() {
		final int idPet = 1;
		final String name = "Tallulah";
		final int idMaster = 2;
		
		
		final Pet pet = new Pet(idPet,name,idMaster);
		pet.setIdMaster(7);;
		
		assertThat(pet.getIdPet(), is(idPet));
		assertThat(pet.getName(), is(name));
		assertThat(pet.getIdMaster(), is(7));
	}
	


	@Test
	public void testEqualsObject() {
		final Pet petA = new Pet(1, "Name A", 3);
		final Pet petB = new Pet(1, "Name B", 5);
		
		assertTrue(petA.equals(petB));
	}

	@Test
	public void testEqualsHashcode() {
		EqualsVerifier.forClass(Pet.class)
			.withIgnoredFields("name", "idMaster")
			.suppress(Warning.STRICT_INHERITANCE)
			.suppress(Warning.NONFINAL_FIELDS)
		.verify();
	}

}
