package es.uvigo.esei.daa.matchers;

import static java.util.Objects.requireNonNull;

import org.hamcrest.Factory;
import org.hamcrest.Matcher;

import es.uvigo.esei.daa.entities.Pet;

public class IsEqualToPet extends IsEqualToEntity<Pet> {

	public IsEqualToPet(Pet entity) {
		super(entity);
	}

	@Override
	protected boolean matchesSafely(Pet actual) {
		this.clearDescribeTo();
		
		if (actual == null) {
			this.addTemplatedDescription("actual", expected.toString());
			return false;
		} else {
			return checkAttribute("idPet", Pet::getIdPet, actual)
				&& checkAttribute("name", Pet::getName, actual)
				&& checkAttribute("idMaster", Pet::getIdMaster, actual);
		}
	}


	@Factory
	public static IsEqualToPet equalsToPet(Pet Pet) {
		return new IsEqualToPet(Pet);
	}
	

	@Factory
	public static Matcher<Iterable<? extends Pet>> containsPetsInAnyOrder(Pet ... Pets) {
		return containsEntityInAnyOrder(IsEqualToPet::equalsToPet, Pets);
	}

}
